/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.Arrays;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class DataTypeUtils {
    public static boolean hasSmallPrecisionDecimalType(DataType sparkType) {
        if (sparkType instanceof StructType) {
            StructField[] fields = ((StructType)sparkType).fields();
            return Arrays.stream(fields).anyMatch(f -> DataTypeUtils.hasSmallPrecisionDecimalType(f.dataType()));
        }
        if (sparkType instanceof MapType) {
            MapType map = (MapType)sparkType;
            return DataTypeUtils.hasSmallPrecisionDecimalType(map.keyType()) || DataTypeUtils.hasSmallPrecisionDecimalType(map.valueType());
        }
        if (sparkType instanceof ArrayType) {
            return DataTypeUtils.hasSmallPrecisionDecimalType(((ArrayType)sparkType).elementType());
        }
        if (sparkType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)sparkType;
            return decimalType.precision() < Decimal.MAX_LONG_DIGITS();
        }
        return false;
    }
}

