/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.utilities.IdentitySplitter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class HoodieCleaner {
    private static final Logger LOG = LogManager.getLogger(HoodieCleaner.class);
    private final Config cfg;
    private transient JavaSparkContext jssc;
    private TypedProperties props;

    public HoodieCleaner(Config cfg, JavaSparkContext jssc) {
        this.cfg = cfg;
        this.jssc = jssc;
        this.props = cfg.propsFilePath == null ? UtilHelpers.buildProperties(cfg.configs) : UtilHelpers.readConfig(jssc.hadoopConfiguration(), new Path(cfg.propsFilePath), cfg.configs).getProps(true);
        LOG.info((Object)("Creating Cleaner with configs : " + this.props.toString()));
    }

    public void run() {
        HoodieWriteConfig hoodieCfg = this.getHoodieClientConfig();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient(new HoodieSparkEngineContext(this.jssc), hoodieCfg);){
            client.clean();
        }
    }

    private HoodieWriteConfig getHoodieClientConfig() {
        return HoodieWriteConfig.newBuilder().combineInput(true, true).withPath(this.cfg.basePath).withAutoCommit(false).withProps(this.props).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args2);
        if (cfg.help.booleanValue() || args2.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        String dirName = new Path(cfg.basePath).getName();
        JavaSparkContext jssc = UtilHelpers.buildSparkContext("hoodie-cleaner-" + dirName, cfg.sparkMaster);
        try {
            new HoodieCleaner(cfg, jssc).run();
        }
        catch (Throwable throwable) {
            LOG.error((Object)("Fail to run cleaning for " + cfg.basePath), throwable);
        }
        finally {
            jssc.stop();
        }
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--target-base-path"}, description="base path for the hoodie table to be cleaner.", required=true)
        public String basePath;
        @Parameter(names={"--props"}, description="path to properties file on localfs or dfs, with configurations for hoodie client for cleaning")
        public String propsFilePath = null;
        @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--props\") can also be passed command line using this parameter. This can be repeated", splitter=IdentitySplitter.class)
        public List<String> configs = new ArrayList<String>();
        @Parameter(names={"--spark-master"}, description="spark master to use.")
        public String sparkMaster = "local[2]";
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
    }
}

