/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.TaggedFields;
import org.apache.kafka.common.protocol.types.Type;

public class Protocol {
    private static String indentString(int size) {
        StringBuilder b = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    private static void schemaToBnfHtml(Schema schema, StringBuilder b, int indentSize) {
        String indentStr = Protocol.indentString(indentSize);
        LinkedHashMap<String, Type> subTypes = new LinkedHashMap<String, Type>();
        for (BoundField field : schema.fields()) {
            Type type = field.def.type;
            if (type.isArray()) {
                b.append("[");
                b.append(field.def.name);
                b.append("] ");
                if (subTypes.containsKey(field.def.name)) continue;
                subTypes.put(field.def.name, type.arrayElementType().get());
                continue;
            }
            if (type instanceof TaggedFields) {
                b.append("TAG_BUFFER ");
                continue;
            }
            b.append(field.def.name);
            b.append(" ");
            if (subTypes.containsKey(field.def.name)) continue;
            subTypes.put(field.def.name, type);
        }
        b.append("\n");
        for (Map.Entry entry : subTypes.entrySet()) {
            if (entry.getValue() instanceof Schema) {
                b.append(indentStr);
                b.append((String)entry.getKey());
                b.append(" => ");
                Protocol.schemaToBnfHtml((Schema)entry.getValue(), b, indentSize + 2);
                continue;
            }
            b.append(indentStr);
            b.append((String)entry.getKey());
            b.append(" => ");
            b.append(entry.getValue());
            b.append("\n");
        }
    }

    private static void populateSchemaFields(Schema schema, Set<BoundField> fields) {
        for (BoundField field : schema.fields()) {
            fields.add(field);
            if (field.def.type.isArray()) {
                Type innerType = field.def.type.arrayElementType().get();
                if (!(innerType instanceof Schema)) continue;
                Protocol.populateSchemaFields((Schema)innerType, fields);
                continue;
            }
            if (!(field.def.type instanceof Schema)) continue;
            Protocol.populateSchemaFields((Schema)field.def.type, fields);
        }
    }

    private static void schemaToFieldTableHtml(Schema schema, StringBuilder b) {
        LinkedHashSet<BoundField> fields = new LinkedHashSet<BoundField>();
        Protocol.populateSchemaFields(schema, fields);
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Field</th>\n");
        b.append("<th>Description</th>\n");
        b.append("</tr>");
        for (BoundField field : fields) {
            b.append("<tr>\n");
            b.append("<td>");
            b.append(field.def.name);
            b.append("</td>");
            b.append("<td>");
            b.append(field.def.docString);
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
    }

    public static String toHtml() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("<h5>Headers:</h5>\n");
        for (i = 0; i < RequestHeaderData.SCHEMAS.length; ++i) {
            b.append("<pre>");
            b.append("Request Header v").append(i).append(" => ");
            Protocol.schemaToBnfHtml(RequestHeaderData.SCHEMAS[i], b, 2);
            b.append("</pre>\n");
            Protocol.schemaToFieldTableHtml(RequestHeaderData.SCHEMAS[i], b);
        }
        for (i = 0; i < ResponseHeaderData.SCHEMAS.length; ++i) {
            b.append("<pre>");
            b.append("Response Header v").append(i).append(" => ");
            Protocol.schemaToBnfHtml(ResponseHeaderData.SCHEMAS[i], b, 2);
            b.append("</pre>\n");
            Protocol.schemaToFieldTableHtml(ResponseHeaderData.SCHEMAS[i], b);
        }
        for (ApiKeys key : ApiKeys.values()) {
            b.append("<h5>");
            b.append("<a name=\"The_Messages_" + key.name + "\">");
            b.append(key.name);
            b.append(" API (Key: ");
            b.append(key.id);
            b.append("):</a></h5>\n\n");
            b.append("<b>Requests:</b><br>\n");
            Schema[] requests = key.requestSchemas;
            for (int i2 = 0; i2 < requests.length; ++i2) {
                Schema schema = requests[i2];
                if (schema != null) {
                    b.append("<p>");
                    b.append("<pre>");
                    b.append(key.name);
                    b.append(" Request (Version: ");
                    b.append(i2);
                    b.append(") => ");
                    Protocol.schemaToBnfHtml(requests[i2], b, 2);
                    b.append("</pre>");
                    Protocol.schemaToFieldTableHtml(requests[i2], b);
                }
                b.append("</p>\n");
            }
            b.append("<b>Responses:</b><br>\n");
            Schema[] responses = key.responseSchemas;
            for (int i3 = 0; i3 < responses.length; ++i3) {
                Schema schema = responses[i3];
                if (schema != null) {
                    b.append("<p>");
                    b.append("<pre>");
                    b.append(key.name);
                    b.append(" Response (Version: ");
                    b.append(i3);
                    b.append(") => ");
                    Protocol.schemaToBnfHtml(responses[i3], b, 2);
                    b.append("</pre>");
                    Protocol.schemaToFieldTableHtml(responses[i3], b);
                }
                b.append("</p>\n");
            }
        }
        return b.toString();
    }

    public static void main(String[] args2) {
        System.out.println(Protocol.toHtml());
    }
}

