/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class HoodieSchemaUtils$ {
    public static HoodieSchemaUtils$ MODULE$;
    private final Logger log;

    static {
        new HoodieSchemaUtils$();
    }

    private Logger log() {
        return this.log;
    }

    public scala.Option<InternalSchema> getLatestTableInternalSchema(HoodieConfig config, HoodieTableMetaClient tableMetaClient) {
        None$ none$;
        block5: {
            if (!config.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
                none$ = None$.MODULE$;
            } else {
                try {
                    TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
                    Option<InternalSchema> internalSchemaOpt = tableSchemaResolver.getTableInternalSchemaFromCommitMetadata();
                    if (internalSchemaOpt.isPresent()) {
                        none$ = new Some((Object)internalSchemaOpt.get());
                        break block5;
                    }
                    none$ = None$.MODULE$;
                }
                catch (Exception exception) {
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        Schema schema;
        boolean setNullForMissingColumns = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().key(), DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().defaultValue()))).toBoolean();
        boolean shouldReconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)opts.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
        boolean shouldValidateSchemasCompatibility = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue()))).toBoolean();
        scala.Option<Schema> option = latestTableSchemaOpt;
        if (None$.MODULE$.equals(option)) {
            return AvroInternalSchemaConverter.fixNullOrdering(sourceSchema);
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        Some some = (Some)option;
        Schema latestTableSchemaWithMetaFields = (Schema)some.value();
        Schema latestTableSchema = AvroInternalSchemaConverter.fixNullOrdering(HoodieAvroUtils.removeMetadataFields(latestTableSchemaWithMetaFields));
        boolean shouldCanonicalizeSchema = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().key(), HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().defaultValue().toString()))).toBoolean();
        boolean mergeIntoWrites = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().key(), HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().defaultValue().toString()))).toBoolean();
        Schema canonicalizedSourceSchema = shouldCanonicalizeSchema ? this.canonicalizeSchema(sourceSchema, latestTableSchema, opts) : AvroInternalSchemaConverter.fixNullOrdering(sourceSchema);
        boolean allowAutoEvolutionColumnDrop = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key(), HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.defaultValue()))).toBoolean();
        if (shouldReconcileSchema) {
            Schema schema2;
            scala.Option<InternalSchema> option2 = internalSchemaOpt;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                InternalSchema internalSchema = (InternalSchema)some2.value();
                InternalSchema mergedInternalSchema = AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, internalSchema);
                Schema evolvedSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema, latestTableSchema.getFullName());
                boolean shouldRemoveMetaDataFromInternalSchema = ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(sourceSchema.getFields()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSchemaUtils$.$anonfun$deduceWriterSchema$1(f)))).isEmpty();
                schema2 = shouldRemoveMetaDataFromInternalSchema ? HoodieAvroUtils.removeMetadataFields(evolvedSchema) : evolvedSchema;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                Tuple2<Schema, Object> tuple2 = this.reconcileSchemasLegacy(latestTableSchema, canonicalizedSourceSchema);
                if (tuple2 == null) throw new MatchError(tuple2);
                Schema reconciledSchema = (Schema)tuple2._1();
                boolean isCompatible = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)reconciledSchema, (Object)BoxesRunTime.boxToBoolean((boolean)isCompatible));
                Tuple2 tuple23 = tuple22;
                Schema reconciledSchema2 = (Schema)tuple23._1();
                boolean isCompatible2 = tuple23._2$mcZ$sp();
                if (shouldValidateSchemasCompatibility && !isCompatible2) {
                    this.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(218).append("Failed to reconcile incoming batch schema with the table's one.\n                     |Incoming schema ").append(sourceSchema.toString(true)).append("\n                     |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n                     |Table's schema ").append(latestTableSchema.toString(true)).append("\n                     |").toString())).stripMargin());
                    throw new SchemaCompatibilityException("Failed to reconcile incoming schema with the table's one");
                }
                schema2 = reconciledSchema2;
            }
            schema = schema2;
            return schema;
        }
        if (mergeIntoWrites) {
            schema = canonicalizedSourceSchema;
            return schema;
        }
        if (!shouldValidateSchemasCompatibility) {
            if (allowAutoEvolutionColumnDrop) {
                schema = canonicalizedSourceSchema;
                return schema;
            } else {
                Schema reconciledSchema;
                Schema schema3 = reconciledSchema = setNullForMissingColumns ? AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, latestTableSchema) : canonicalizedSourceSchema;
                if (!AvroSchemaUtils.isValidEvolutionOf(reconciledSchema, latestTableSchema)) {
                    this.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(224).append("Incoming batch schema is not compatible with the table's one.\n                       |Incoming schema ").append(sourceSchema.toString(true)).append("\n                       |Incoming schema (canonicalized) ").append(reconciledSchema.toString(true)).append("\n                       |Table's schema ").append(latestTableSchema.toString(true)).append("\n                       |").toString())).stripMargin());
                    throw new SchemaCompatibilityException("Incoming batch schema is not compatible with the table's one");
                }
                schema = reconciledSchema;
            }
            return schema;
        }
        if (!AvroSchemaUtils.isSchemaCompatible(latestTableSchema, canonicalizedSourceSchema, allowAutoEvolutionColumnDrop)) {
            this.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(208).append("Incoming batch schema is not compatible with the table's one.\n                   |Incoming schema ").append(sourceSchema.toString(true)).append("\n                   |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n                   |Table's schema ").append(latestTableSchema.toString(true)).append("\n                   |").toString())).stripMargin());
            throw new SchemaCompatibilityException("Incoming batch schema is not compatible with the table's one");
        }
        schema = canonicalizedSourceSchema;
        return schema;
    }

    private Schema canonicalizeSchema(Schema sourceSchema, Schema latestTableSchema, Map<String, String> opts) {
        return AvroSchemaEvolutionUtils.reconcileSchemaRequirements(sourceSchema, latestTableSchema, JavaConversions$.MODULE$.mapAsJavaMap(opts));
    }

    private Tuple2<Schema, Object> reconcileSchemasLegacy(Schema tableSchema, Schema newSchema) {
        return AvroSchemaUtils.isCompatibleProjectionOf(tableSchema, newSchema) ? new Tuple2((Object)tableSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(newSchema, tableSchema))) : new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(tableSchema, newSchema)));
    }

    public static final /* synthetic */ boolean $anonfun$deduceWriterSchema$1(Schema.Field f) {
        return f.name().equalsIgnoreCase(HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    private HoodieSchemaUtils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

