/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieSchemaUtils$;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkSqlWriterInternal;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metrics.Metrics;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.runtime.BoxesRunTime;

public final class HoodieSparkSqlWriter$ {
    public static HoodieSparkSqlWriter$ MODULE$;
    private final ConfigProperty<Object> CANONICALIZE_SCHEMA;
    private final ConfigProperty<Object> SQL_MERGE_INTO_WRITES;
    private final String SPARK_STREAMING_BATCH_ID;

    static {
        new HoodieSparkSqlWriter$();
    }

    public ConfigProperty<Object> CANONICALIZE_SCHEMA() {
        return this.CANONICALIZE_SCHEMA;
    }

    public ConfigProperty<Object> SQL_MERGE_INTO_WRITES() {
        return this.SQL_MERGE_INTO_WRITES;
    }

    public String SPARK_STREAMING_BATCH_ID() {
        return this.SPARK_STREAMING_BATCH_ID;
    }

    public Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<?>, HoodieTableConfig> write(SQLContext sqlContext, SaveMode mode, Map<String, String> optParams, Dataset<Row> sourceDf, scala.Option<HoodieSparkSqlWriter.StreamingWriteParams> streamingWritesParamsOpt, scala.Option<SparkRDDWriteClient<?>> hoodieWriteClient) {
        return new HoodieSparkSqlWriterInternal().write(sqlContext, mode, optParams, sourceDf, streamingWritesParamsOpt, hoodieWriteClient);
    }

    public scala.Option<HoodieSparkSqlWriter.StreamingWriteParams> write$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<?>> write$default$6() {
        return Option$.MODULE$.empty();
    }

    public boolean bootstrap(SQLContext sqlContext, SaveMode mode, Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<HoodieSparkSqlWriter.StreamingWriteParams> streamingWritesParamsOpt, scala.Option<SparkRDDWriteClient<?>> hoodieWriteClient) {
        return new HoodieSparkSqlWriterInternal().bootstrap(sqlContext, mode, optParams, df, hoodieTableConfigOpt, streamingWritesParamsOpt, hoodieWriteClient);
    }

    public scala.Option<HoodieTableConfig> bootstrap$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<HoodieSparkSqlWriter.StreamingWriteParams> bootstrap$default$6() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<?>> bootstrap$default$7() {
        return Option$.MODULE$.empty();
    }

    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        return HoodieSchemaUtils$.MODULE$.deduceWriterSchema(sourceSchema, latestTableSchemaOpt, internalSchemaOpt, opts);
    }

    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, TypedProperties props) {
        return this.deduceWriterSchema(sourceSchema, latestTableSchemaOpt, internalSchemaOpt, HoodieConversionUtils$.MODULE$.fromProperties(props));
    }

    public void cleanup() {
        Metrics.shutdownAllMetrics();
    }

    public HoodieWriteConfig getBulkInsertRowConfig(Option<Schema> writerSchema, HoodieConfig hoodieConfig, String basePath, String tblName) {
        scala.collection.mutable.Map opts;
        String writerSchemaStr;
        block1: {
            writerSchemaStr = null;
            if (writerSchema.isPresent()) {
                writerSchemaStr = writerSchema.get().toString();
            }
            scala.collection.mutable.Map optsWithoutSchema = ((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap((Properties)hoodieConfig.getProps()).toMap(Predef$.MODULE$.$conforms()));
            scala.collection.mutable.Map map = opts = writerSchema.isPresent() ? optsWithoutSchema.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.AVRO_SCHEMA_STRING.key()), (Object)writerSchemaStr)}))) : optsWithoutSchema;
            if (!writerSchema.isPresent()) break block1;
            DataSourceUtils.tryOverrideParquetWriteLegacyFormatProperty(JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap(opts), AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(writerSchema.get()));
        }
        return DataSourceUtils.createHoodieConfig(writerSchemaStr, basePath, tblName, JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap(opts));
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.CANONICALIZE_SCHEMA = ConfigProperty.key("hoodie.internal.write.schema.canonicalize").defaultValue(BoxesRunTime.boxToBoolean((boolean)true));
        this.SQL_MERGE_INTO_WRITES = ConfigProperty.key("hoodie.internal.sql.merge.into.writes").defaultValue(BoxesRunTime.boxToBoolean((boolean)false));
        this.SPARK_STREAMING_BATCH_ID = "hoodie.internal.spark.streaming.batch.id";
    }
}

