/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataLogRecordReader;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.hudi.SparkAdapter;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class LogFileIterator$
implements SparkAdapterSupport {
    public static LogFileIterator$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new LogFileIterator$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        LogFileIterator$ logFileIterator$ = this;
        synchronized (logFileIterator$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public Map<String, HoodieRecord<?>> scanLog(List<HoodieLogFile> logFiles, Path partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        Map map;
        String tablePath = tableState.tablePath();
        FileSystem fs = FSUtils.getFs(tablePath, hadoopConf);
        if (HoodieTableMetadata.isMetadataTable(tablePath)) {
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(tableState.metadataConfig().getProps()).withSpillableMapDir(hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/")).enable(true).build();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable(tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(hadoopConf), metadataConfig, dataTableBasePath);
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath(new Path(tablePath), partitionPath);
            HoodieMetadataLogRecordReader logRecordReader = metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption(new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan)))).getLeft();
            java.util.List recordList = (java.util.List)this.closing(logRecordReader, (Function0 & Serializable & scala.Serializable)() -> logRecordReader.getRecords());
            map = (Map)HashMap$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(recordList).asScala()).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getRecordKey(), r), Buffer$.MODULE$.canBuildFrom()));
        } else {
            HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1 & Serializable & scala.Serializable)logFile -> logFile.getPath().toString(), List$.MODULE$.canBuildFrom())).asJava())).withReaderSchema(logSchema).withLatestInstantTime((String)tableState.latestCommitTimestamp().get()).withReadBlocksLazily(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(hadoopConf.get("compaction.lazy.block.read.enabled", "true"))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt("hoodie.memory.dfs.buffer.max.size", 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/")).withDiskMapType((ExternalSpillableMap.DiskMapType)hadoopConf.getEnum(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Enum)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue())).withBitCaskDiskMapCompressionEnabled(hadoopConf.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Predef$.MODULE$.Boolean2boolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())));
            Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath(new Path(tableState.tablePath()), ((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
            logRecordScannerBuilder.withRecordMerger(HoodieRecordUtils.createRecordMerger(tableState.tablePath(), EngineType.SPARK, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(tableState.recordMergerImpls()).asJava(), tableState.recordMergerStrategy()));
            HoodieMergedLogRecordScanner scanner = logRecordScannerBuilder.build();
            map = (Map)this.closing(scanner, (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(scanner.getRecords()).asScala()).toSeq()));
        }
        return map;
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public <T> T closing(Closeable c, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        finally {
            c.close();
        }
        return (T)object;
    }

    public Path getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((Path)split.dataFile().map((Function1 & Serializable & scala.Serializable)baseFile -> MODULE$.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile((PartitionedFile)baseFile)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((HoodieLogFile)split.logFiles().head()).getPath())).getParent();
    }

    private LogFileIterator$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
    }
}

