/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.io.IOException;
import org.apache.hudi.client.HoodieTimelineArchiver;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchiveExecutorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveExecutorUtils.class);

    private ArchiveExecutorUtils() {
    }

    public static int archive(JavaSparkContext jsc, int minCommits, int maxCommits, int commitsRetained, boolean enableMetadata, String basePath) throws IOException {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(basePath).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(minCommits, maxCommits).build()).withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(commitsRetained).build()).withEmbeddedTimelineServerEnabled(false).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(enableMetadata).build()).build();
        HoodieSparkEngineContext context = new HoodieSparkEngineContext(jsc);
        HoodieSparkTable table = HoodieSparkTable.create(config, context);
        try {
            HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(config, table);
            archiver.archiveIfRequired(context, true);
        }
        catch (IOException ioe) {
            LOG.error("Failed to archive with IOException: " + ioe);
            throw ioe;
        }
        return 0;
    }
}

