/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDTableServiceClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRDDWriteClient<T>
extends BaseHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRDDWriteClient.class);

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        this(context, clientConfig, Option.empty());
    }

    @Deprecated
    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending) {
        this(context, writeConfig, Option.empty());
    }

    @Deprecated
    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending, Option<EmbeddedTimelineService> timelineService) {
        this(context, writeConfig, timelineService);
    }

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService, SparkUpgradeDowngradeHelper.getInstance());
        this.tableServiceClient = new SparkRDDTableServiceClient(context, writeConfig, this.getTimelineServer());
    }

    @Override
    protected HoodieIndex createIndex(HoodieWriteConfig writeConfig) {
        return SparkHoodieIndexFactory.createIndex(this.config);
    }

    @Override
    public boolean commit(String instantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Committing stats: " + this.config.getTableName());
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        return this.commitStats(instantTime, HoodieJavaRDD.of(writeStatuses), writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds, extraPreCommitFunc);
    }

    @Override
    protected HoodieTable createTable(HoodieWriteConfig config, Configuration hadoopConf) {
        return HoodieSparkTable.create(config, this.context);
    }

    @Override
    protected HoodieTable createTable(HoodieWriteConfig config, Configuration hadoopConf, HoodieTableMetaClient metaClient) {
        return HoodieSparkTable.create(config, this.context, metaClient);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> filterExists(JavaRDD<HoodieRecord<T>> hoodieRecords) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        JavaRDD recordsWithLocation = HoodieJavaRDD.getJavaRDD(this.getIndex().tagLocation(HoodieJavaRDD.of(hoodieRecords), this.context, (HoodieTable)table));
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.filter((Function & Serializable)v1 -> !v1.isCurrentLocationKnown());
    }

    @Override
    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        this.initTable(WriteOperationType.UPSERT, Option.ofNullable("00000000000001")).bootstrap(this.context, extraMetadata);
    }

    @Override
    public JavaRDD<WriteStatus> upsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, Option.ofNullable(instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.upsert(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", result.getIndexLookupDuration().get().toMillis());
        }
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> upsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.upsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.insert(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.insertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    public HoodieWriteResult insertOverwrite(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_OVERWRITE, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE, table.getMetaClient());
        HoodieWriteMetadata result = table.insertOverwrite(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult(this.postWrite(resultRDD, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    public HoodieWriteResult insertOverwriteTable(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_OVERWRITE_TABLE, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE_TABLE, table.getMetaClient());
        HoodieWriteMetadata result = table.insertOverwriteTable(this.context, instantTime, HoodieJavaRDD.of(records));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult(this.postWrite(resultRDD, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        return this.bulkInsert(records, instantTime, Option.empty());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsert(this.context, instantTime, HoodieJavaRDD.of(records), userDefinedBulkInsertPartitioner);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords), bulkInsertPartitioner);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> delete(JavaRDD<HoodieKey> keys2, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE, Option.ofNullable(instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE, table.getMetaClient());
        HoodieWriteMetadata result = table.delete(this.context, instantTime, HoodieJavaRDD.of(keys2));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> deletePrepped(JavaRDD<HoodieRecord<T>> preppedRecord, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE_PREPPED, Option.ofNullable(instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.deletePrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecord));
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return this.postWrite(resultRDD, instantTime, table);
    }

    public HoodieWriteResult deletePartitions(List<String> partitions, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE_PARTITION, Option.ofNullable(instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE_PARTITION, table.getMetaClient());
        HoodieWriteMetadata result = table.deletePartitions(this.context, instantTime, partitions);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return new HoodieWriteResult(this.postWrite(resultRDD, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    protected void initMetadataTable(Option<String> instantTime) {
        this.initializeMetadataTable(instantTime);
    }

    private void initializeMetadataTable(Option<String> inFlightInstantTimestamp) {
        if (!this.config.isMetadataTableEnabled()) {
            return;
        }
        try (HoodieTableMetadataWriter writer = SparkHoodieBackedTableMetadataWriter.create(this.context.getHadoopConf().get(), this.config, this.context, inFlightInstantTimestamp);){
            if (writer.isInitialized()) {
                writer.performTableServices(inFlightInstantTimestamp);
            }
        }
        catch (Exception e) {
            throw new HoodieException("Failed to instantiate Metadata table ", e);
        }
    }

    @Override
    protected void initWrapperFSMetrics() {
        if (this.config.isMetricsOn()) {
            Registry registryMeta;
            Registry registry;
            JavaSparkContext jsc = ((HoodieSparkEngineContext)this.context).getJavaSparkContext();
            if (this.config.isExecutorMetricsEnabled()) {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName(), DistributedRegistry.class.getName());
                ((DistributedRegistry)registry).register(jsc);
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder", DistributedRegistry.class.getName());
                ((DistributedRegistry)registryMeta).register(jsc);
            } else {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName());
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder");
            }
            HoodieWrapperFileSystem.setMetricsRegistry(registry, registryMeta);
        }
    }

    @Override
    protected void releaseResources(String instantTime) {
        if (this.config.areReleaseResourceEnabled()) {
            HoodieSparkEngineContext sparkEngineContext = (HoodieSparkEngineContext)this.context;
            Map allCachedRdds = sparkEngineContext.getJavaSparkContext().getPersistentRDDs();
            ArrayList<Integer> allDataIds = new ArrayList<Integer>(sparkEngineContext.removeCachedDataIds(HoodieData.HoodieDataCacheKey.of(this.basePath, instantTime)));
            if (this.config.isMetadataTableEnabled()) {
                String metadataTableBasePath = HoodieTableMetadata.getMetadataTableBasePath(this.basePath);
                allDataIds.addAll(sparkEngineContext.removeCachedDataIds(HoodieData.HoodieDataCacheKey.of(metadataTableBasePath, instantTime)));
            }
            Iterator iterator2 = allDataIds.iterator();
            while (iterator2.hasNext()) {
                int id = (Integer)iterator2.next();
                if (!allCachedRdds.containsKey(id)) continue;
                ((JavaRDD)allCachedRdds.get(id)).unpersist();
            }
        }
    }
}

