/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.transaction.lock.LockInfo;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.StorageSchemes;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBasedLockProvider
implements LockProvider<String>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemBasedLockProvider.class);
    private static final String LOCK_FILE_NAME = "lock";
    private final int lockTimeoutMinutes;
    private final transient FileSystem fs;
    private final transient Path lockFile;
    protected LockConfiguration lockConfiguration;
    private SimpleDateFormat sdf;
    private LockInfo lockInfo;
    private String currentOwnerLockInfo;

    public FileSystemBasedLockProvider(LockConfiguration lockConfiguration, Configuration configuration) {
        this.checkRequiredProps(lockConfiguration);
        this.lockConfiguration = lockConfiguration;
        String lockDirectory = lockConfiguration.getConfig().getString("hoodie.write.lock.filesystem.path", null);
        if (StringUtils.isNullOrEmpty(lockDirectory)) {
            lockDirectory = lockConfiguration.getConfig().getString(HoodieWriteConfig.BASE_PATH.key()) + "/" + ".hoodie";
        }
        this.lockTimeoutMinutes = lockConfiguration.getConfig().getInteger("hoodie.write.lock.filesystem.expire");
        this.lockFile = new Path(lockDirectory + "/" + LOCK_FILE_NAME);
        this.lockInfo = new LockInfo();
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.fs = FSUtils.getFs(this.lockFile.toString(), configuration);
        List<String> customSupportedFSs = lockConfiguration.getConfig().getStringList(HoodieCommonConfig.HOODIE_FS_ATOMIC_CREATION_SUPPORT.key(), ",", new ArrayList<String>());
        if (!customSupportedFSs.contains(this.fs.getScheme()) && !StorageSchemes.isAtomicCreationSupported(this.fs.getScheme())) {
            throw new HoodieLockException("Unsupported scheme :" + this.fs.getScheme() + ", since this fs can not support atomic creation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        String string = LOCK_FILE_NAME;
        synchronized (LOCK_FILE_NAME) {
            try {
                this.fs.delete(this.lockFile, true);
            }
            catch (IOException e) {
                throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE), e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        try {
            String string = LOCK_FILE_NAME;
            synchronized (LOCK_FILE_NAME) {
                if (this.fs.exists(this.lockFile)) {
                    if (this.checkIfExpired()) {
                        this.fs.delete(this.lockFile, true);
                        LOG.warn("Delete expired lock file: " + this.lockFile);
                    } else {
                        this.reloadCurrentOwnerLockInfo();
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        return false;
                    }
                }
                this.acquireLock();
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return this.fs.exists(this.lockFile);
            }
        }
        catch (IOException | HoodieIOException e) {
            LOG.info(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        String string = LOCK_FILE_NAME;
        synchronized (LOCK_FILE_NAME) {
            try {
                if (this.fs.exists(this.lockFile)) {
                    this.fs.delete(this.lockFile, true);
                }
            }
            catch (IOException io) {
                throw new HoodieIOException(this.generateLogStatement(LockState.FAILED_TO_RELEASE), io);
            }
            return;
        }
    }

    @Override
    public String getLock() {
        return this.lockFile.toString();
    }

    @Override
    public String getCurrentOwnerLockInfo() {
        return this.currentOwnerLockInfo;
    }

    private boolean checkIfExpired() {
        if (this.lockTimeoutMinutes == 0) {
            return false;
        }
        try {
            long modificationTime = this.fs.getFileStatus(this.lockFile).getModificationTime();
            if (System.currentTimeMillis() - modificationTime > (long)(this.lockTimeoutMinutes * 60) * 1000L) {
                return true;
            }
        }
        catch (IOException | HoodieIOException e) {
            LOG.error(this.generateLogStatement(LockState.ALREADY_RELEASED) + " failed to get lockFile's modification time", (Throwable)e);
        }
        return false;
    }

    private void acquireLock() {
        try {
            if (!this.fs.exists(this.lockFile)) {
                FSDataOutputStream fos = this.fs.create(this.lockFile, false);
                this.initLockInfo();
                fos.writeBytes(this.lockInfo.toString());
                fos.close();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE), e);
        }
    }

    public void initLockInfo() {
        this.lockInfo.setLockCreateTime(this.sdf.format(System.currentTimeMillis()));
        this.lockInfo.setLockThreadName(Thread.currentThread().getName());
        this.lockInfo.setLockStacksInfo(Thread.currentThread().getStackTrace());
    }

    public void reloadCurrentOwnerLockInfo() {
        try {
            if (this.fs.exists(this.lockFile)) {
                FSDataInputStream fis = this.fs.open(this.lockFile);
                this.currentOwnerLockInfo = FileIOUtils.readAsUTFString((InputStream)fis);
                fis.close();
            } else {
                this.currentOwnerLockInfo = "";
            }
        }
        catch (IOException e) {
            throw new HoodieIOException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE), e);
        }
    }

    protected String generateLogStatement(LockState state) {
        return StringUtils.join(state.name(), " lock at: ", this.getLock());
    }

    private void checkRequiredProps(LockConfiguration config) {
        ValidationUtils.checkArgument(config.getConfig().getString("hoodie.write.lock.filesystem.path", null) != null || config.getConfig().getString(HoodieWriteConfig.BASE_PATH.key(), null) != null);
        ValidationUtils.checkArgument(config.getConfig().getInteger("hoodie.write.lock.filesystem.expire") >= 0);
    }

    public static TypedProperties getLockConfig(String tablePath) {
        TypedProperties props = new TypedProperties();
        props.put(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), FileSystemBasedLockProvider.class.getName());
        props.put(HoodieLockConfig.LOCK_ACQUIRE_WAIT_TIMEOUT_MS.key(), "2000");
        props.put(HoodieLockConfig.FILESYSTEM_LOCK_EXPIRE.key(), "1");
        props.put(HoodieLockConfig.LOCK_ACQUIRE_CLIENT_NUM_RETRIES.key(), "30");
        props.put(HoodieLockConfig.FILESYSTEM_LOCK_PATH.key(), FileSystemBasedLockProvider.defaultLockPath(tablePath));
        return props;
    }

    private static String defaultLockPath(String tablePath) {
        return tablePath + "/" + ".hoodie/.aux";
    }
}

