/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class HoodieSerializableFileStatus
implements Serializable {
    private Path path;
    private long length;
    private Boolean isDir;
    private short blockReplication;
    private long blockSize;
    private long modificationTime;
    private long accessTime;
    private FsPermission permission;
    private String owner;
    private String group;
    private Path symlink;

    HoodieSerializableFileStatus(Path path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, FsPermission permission, String owner, String group, Path symlink) {
        this.path = path;
        this.length = length;
        this.isDir = isDir;
        this.blockReplication = blockReplication;
        this.blockSize = blockSize;
        this.modificationTime = modificationTime;
        this.accessTime = accessTime;
        this.permission = permission;
        this.owner = owner;
        this.group = group;
        this.symlink = symlink;
    }

    public Path getPath() {
        return this.path;
    }

    public long getLen() {
        return this.length;
    }

    public Boolean isDirectory() {
        return this.isDir;
    }

    public short getReplication() {
        return this.blockReplication;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public Path getSymlink() {
        return this.symlink;
    }

    public static HoodieSerializableFileStatus fromFileStatus(FileStatus status) {
        Path symlink;
        try {
            symlink = status.getSymlink();
        }
        catch (IOException ioe) {
            symlink = null;
        }
        return new HoodieSerializableFileStatus(status.getPath(), status.getLen(), status.isDir(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission(), status.getOwner(), status.getGroup(), symlink);
    }

    public static HoodieSerializableFileStatus[] fromFileStatuses(FileStatus[] statuses) {
        return Arrays.stream(statuses).map(status -> HoodieSerializableFileStatus.fromFileStatus(status)).collect(Collectors.toList()).toArray(new HoodieSerializableFileStatus[statuses.length]);
    }

    public static FileStatus toFileStatus(HoodieSerializableFileStatus status) {
        return new FileStatus(status.getLen(), status.isDirectory().booleanValue(), (int)status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission(), status.getOwner(), status.getGroup(), status.getSymlink(), status.getPath());
    }

    public static FileStatus[] toFileStatuses(HoodieSerializableFileStatus[] statuses) {
        return Arrays.stream(statuses).map(status -> HoodieSerializableFileStatus.toFileStatus(status)).collect(Collectors.toList()).toArray(new FileStatus[statuses.length]);
    }
}

