/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieLogFormatReader
implements HoodieLogFormat.Reader {
    private final List<HoodieLogFile> logFiles;
    private HoodieLogFileReader currentReader;
    private final FileSystem fs;
    private final Schema readerSchema;
    private InternalSchema internalSchema;
    private final boolean readBlocksLazily;
    private final String recordKeyField;
    private final boolean enableInlineReading;
    private final int bufferSize;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieLogFormatReader.class);

    HoodieLogFormatReader(FileSystem fs, List<HoodieLogFile> logFiles, Schema readerSchema, boolean readBlocksLazily, boolean reverseLogReader, int bufferSize, boolean enableRecordLookups, String recordKeyField, InternalSchema internalSchema) throws IOException {
        this.logFiles = logFiles;
        this.fs = fs;
        this.readerSchema = readerSchema;
        this.readBlocksLazily = readBlocksLazily;
        this.bufferSize = bufferSize;
        this.recordKeyField = recordKeyField;
        this.enableInlineReading = enableRecordLookups;
        InternalSchema internalSchema2 = this.internalSchema = internalSchema == null ? InternalSchema.getEmptyInternalSchema() : internalSchema;
        if (logFiles.size() > 0) {
            HoodieLogFile nextLogFile = logFiles.remove(0);
            this.currentReader = new HoodieLogFileReader(fs, nextLogFile, readerSchema, bufferSize, readBlocksLazily, false, enableRecordLookups, recordKeyField, internalSchema);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentReader == null) {
            return false;
        }
        if (this.currentReader.hasNext()) {
            return true;
        }
        if (this.logFiles.size() > 0) {
            try {
                HoodieLogFile nextLogFile = this.logFiles.remove(0);
                this.currentReader.close();
                this.currentReader = new HoodieLogFileReader(this.fs, nextLogFile, this.readerSchema, this.bufferSize, this.readBlocksLazily, false, this.enableInlineReading, this.recordKeyField, this.internalSchema);
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to initialize read with log file ", io);
            }
            LOG.info("Moving to the next reader for logfile " + this.currentReader.getLogFile());
            return this.hasNext();
        }
        return false;
    }

    @Override
    public HoodieLogBlock next() {
        return this.currentReader.next();
    }

    @Override
    public HoodieLogFile getLogFile() {
        return this.currentReader.getLogFile();
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean hasPrev() {
        return this.currentReader.hasPrev();
    }

    @Override
    public HoodieLogBlock prev() throws IOException {
        return this.currentReader.prev();
    }
}

