/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.FileIOUtils;

@ConfigClassProperty(name="Memory Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Controls memory usage for compaction and merges, performed internally by Hudi.")
@Immutable
public class HoodieMemoryConfig
extends HoodieConfig {
    public static final ConfigProperty<String> MAX_MEMORY_FRACTION_FOR_MERGE = ConfigProperty.key("hoodie.memory.merge.fraction").defaultValue(String.valueOf(0.6)).markAdvanced().withDocumentation("This fraction is multiplied with the user memory fraction (1 - spark.memory.fraction) to get a final fraction of heap space to use during merge");
    public static final ConfigProperty<String> MAX_MEMORY_FRACTION_FOR_COMPACTION = ConfigProperty.key("hoodie.memory.compaction.fraction").defaultValue(String.valueOf(0.6)).markAdvanced().withDocumentation("HoodieCompactedLogScanner reads logblocks, converts records to HoodieRecords and then merges these log blocks and records. At any point, the number of entries in a log block can be less than or equal to the number of entries in the corresponding parquet file. This can lead to OOM in the Scanner. Hence, a spillable map helps alleviate the memory pressure. Use this config to set the max allowable inMemory footprint of the spillable map");
    public static final long DEFAULT_MAX_MEMORY_FOR_SPILLABLE_MAP_IN_BYTES = 0x40000000L;
    public static final long DEFAULT_MIN_MEMORY_FOR_SPILLABLE_MAP_IN_BYTES = 0x6400000L;
    public static final ConfigProperty<Long> MAX_MEMORY_FOR_MERGE = ConfigProperty.key("hoodie.memory.merge.max.size").defaultValue(0x40000000L).markAdvanced().withDocumentation("Maximum amount of memory used  in bytes for merge operations, before spilling to local storage.");
    public static final ConfigProperty<String> MAX_MEMORY_FOR_COMPACTION = HoodieCommonConfig.MAX_MEMORY_FOR_COMPACTION;
    public static final ConfigProperty<Integer> MAX_DFS_STREAM_BUFFER_SIZE = HoodieCommonConfig.MAX_DFS_STREAM_BUFFER_SIZE;
    public static final ConfigProperty<String> SPILLABLE_MAP_BASE_PATH = ConfigProperty.key("hoodie.memory.spillable.map.path").noDefaultValue().markAdvanced().withDocumentation("Default file path for spillable map");
    public static final ConfigProperty<Double> WRITESTATUS_FAILURE_FRACTION = ConfigProperty.key("hoodie.memory.writestatus.failure.fraction").defaultValue(0.1).markAdvanced().withDocumentation("Property to control how what fraction of the failed record, exceptions we report back to driver. Default is 10%. If set to 100%, with lot of failures, this can cause memory pressure, cause OOMs and mask actual data errors.");
    @Deprecated
    public static final String MAX_MEMORY_FRACTION_FOR_MERGE_PROP = MAX_MEMORY_FRACTION_FOR_MERGE.key();
    @Deprecated
    public static final String DEFAULT_MAX_MEMORY_FRACTION_FOR_MERGE = MAX_MEMORY_FRACTION_FOR_MERGE.defaultValue();
    @Deprecated
    public static final String MAX_MEMORY_FRACTION_FOR_COMPACTION_PROP = MAX_MEMORY_FRACTION_FOR_COMPACTION.key();
    @Deprecated
    public static final String DEFAULT_MAX_MEMORY_FRACTION_FOR_COMPACTION = MAX_MEMORY_FRACTION_FOR_COMPACTION.defaultValue();
    @Deprecated
    public static final String MAX_MEMORY_FOR_MERGE_PROP = MAX_MEMORY_FOR_MERGE.key();
    @Deprecated
    public static final String MAX_MEMORY_FOR_COMPACTION_PROP = MAX_MEMORY_FOR_COMPACTION.key();
    @Deprecated
    public static final String MAX_DFS_STREAM_BUFFER_SIZE_PROP = MAX_DFS_STREAM_BUFFER_SIZE.key();
    @Deprecated
    public static final int DEFAULT_MAX_DFS_STREAM_BUFFER_SIZE = MAX_DFS_STREAM_BUFFER_SIZE.defaultValue();
    @Deprecated
    public static final String SPILLABLE_MAP_BASE_PATH_PROP = SPILLABLE_MAP_BASE_PATH.key();
    @Deprecated
    public static final String DEFAULT_SPILLABLE_MAP_BASE_PATH = FileIOUtils.getDefaultSpillableMapBasePath();
    @Deprecated
    public static final String WRITESTATUS_FAILURE_FRACTION_PROP = WRITESTATUS_FAILURE_FRACTION.key();
    @Deprecated
    public static final double DEFAULT_WRITESTATUS_FAILURE_FRACTION = WRITESTATUS_FAILURE_FRACTION.defaultValue();

    private HoodieMemoryConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMemoryConfig memoryConfig = new HoodieMemoryConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.memoryConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.memoryConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withMaxMemoryFractionPerPartitionMerge(double maxMemoryFractionPerPartitionMerge) {
            this.memoryConfig.setValue(MAX_MEMORY_FRACTION_FOR_MERGE, String.valueOf(maxMemoryFractionPerPartitionMerge));
            return this;
        }

        public Builder withMaxMemoryMaxSize(long mergeMaxSize, long compactionMaxSize) {
            this.memoryConfig.setValue(MAX_MEMORY_FOR_MERGE, String.valueOf(mergeMaxSize));
            this.memoryConfig.setValue(MAX_MEMORY_FOR_COMPACTION, String.valueOf(compactionMaxSize));
            return this;
        }

        public Builder withMaxMemoryFractionPerCompaction(double maxMemoryFractionPerCompaction) {
            this.memoryConfig.setValue(MAX_MEMORY_FRACTION_FOR_COMPACTION, String.valueOf(maxMemoryFractionPerCompaction));
            return this;
        }

        public Builder withMaxDFSStreamBufferSize(int maxStreamBufferSize) {
            this.memoryConfig.setValue(MAX_DFS_STREAM_BUFFER_SIZE, String.valueOf(maxStreamBufferSize));
            return this;
        }

        public Builder withWriteStatusFailureFraction(double failureFraction) {
            this.memoryConfig.setValue(WRITESTATUS_FAILURE_FRACTION, String.valueOf(failureFraction));
            return this;
        }

        public HoodieMemoryConfig build() {
            this.memoryConfig.setDefaults(HoodieMemoryConfig.class.getName());
            return this.memoryConfig;
        }
    }
}

