/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.index.bucket.HoodieConsistentBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import scala.Tuple2;

public class HoodieSparkConsistentBucketIndex
extends HoodieConsistentBucketIndex {
    public HoodieSparkConsistentBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable, String instantTime) throws HoodieIndexException {
        HoodieInstant instant = hoodieTable.getMetaClient().getActiveTimeline().findInstantsAfterOrEquals(instantTime, 1).firstInstant().get();
        ValidationUtils.checkState(instant.getTimestamp().equals(instantTime), "Cannot get the same instant, instantTime: " + instantTime);
        if (!instant.getAction().equals("replacecommit")) {
            return writeStatuses;
        }
        Option<Pair<HoodieInstant, HoodieClusteringPlan>> instantPlanPair = ClusteringUtils.getClusteringPlan(hoodieTable.getMetaClient(), HoodieTimeline.getReplaceCommitRequestedInstant(instantTime));
        if (!instantPlanPair.isPresent()) {
            return writeStatuses;
        }
        HoodieClusteringPlan plan = instantPlanPair.get().getRight();
        HoodieJavaRDD.getJavaRDD(context.parallelize(plan.getInputGroups().stream().map(HoodieClusteringGroup::getExtraMetadata).collect(Collectors.toList()))).mapToPair((PairFunction & Serializable)m -> new Tuple2(m.get("clustering.group.partition"), m)).groupByKey().foreach((VoidFunction & Serializable)input -> {
            String partition = (String)input._1();
            ArrayList<ConsistentHashingNode> childNodes = new ArrayList<ConsistentHashingNode>();
            int seqNo = 0;
            for (Map m : (Iterable)input._2()) {
                String nodesJson = (String)m.get("clustering.group.child.node");
                childNodes.addAll(ConsistentHashingNode.fromJsonString(nodesJson));
                seqNo = Integer.parseInt((String)m.get("clustering.group.sequence.no"));
            }
            Option<HoodieConsistentHashingMetadata> metadataOption = ConsistentBucketIndexUtils.loadMetadata(hoodieTable, partition);
            ValidationUtils.checkState(metadataOption.isPresent(), "Failed to load metadata for partition: " + partition);
            HoodieConsistentHashingMetadata meta = metadataOption.get();
            ValidationUtils.checkState(meta.getSeqNo() == seqNo, "Non serialized update to hashing metadata, old seq: " + meta.getSeqNo() + ", new seq: " + seqNo);
            meta.setChildrenNodes(childNodes);
            List<ConsistentHashingNode> newNodes = new ConsistentBucketIdentifier(meta).getNodes().stream().map(n -> new ConsistentHashingNode(n.getValue(), n.getFileIdPrefix(), ConsistentHashingNode.NodeTag.NORMAL)).collect(Collectors.toList());
            HoodieConsistentHashingMetadata newMeta = new HoodieConsistentHashingMetadata(meta.getVersion(), meta.getPartitionPath(), instantTime, meta.getNumBuckets(), seqNo + 1, newNodes);
            ConsistentBucketIndexUtils.saveMetadata(hoodieTable, newMeta, true);
        });
        return writeStatuses;
    }
}

