/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;

public class HoodieKeyLocationFetchHandle<T, I, K, O>
extends HoodieReadHandle<T, I, K, O> {
    private final Pair<String, HoodieBaseFile> partitionPathBaseFilePair;
    private final Option<BaseKeyGenerator> keyGeneratorOpt;

    public HoodieKeyLocationFetchHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, HoodieBaseFile> partitionPathBaseFilePair, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, hoodieTable, Pair.of(partitionPathBaseFilePair.getLeft(), partitionPathBaseFilePair.getRight().getFileId()));
        this.partitionPathBaseFilePair = partitionPathBaseFilePair;
        this.keyGeneratorOpt = keyGeneratorOpt;
    }

    private List<HoodieKey> fetchHoodieKeys(HoodieBaseFile baseFile) {
        BaseFileUtils baseFileUtils = BaseFileUtils.getInstance(baseFile.getPath());
        if (this.keyGeneratorOpt.isPresent()) {
            return baseFileUtils.fetchHoodieKeys(this.hoodieTable.getHadoopConf(), new Path(baseFile.getPath()), this.keyGeneratorOpt);
        }
        return baseFileUtils.fetchHoodieKeys(this.hoodieTable.getHadoopConf(), new Path(baseFile.getPath()));
    }

    public Stream<Pair<HoodieKey, HoodieRecordLocation>> locations() {
        HoodieBaseFile baseFile = this.partitionPathBaseFilePair.getRight();
        String commitTime = baseFile.getCommitTime();
        String fileId = baseFile.getFileId();
        return this.fetchHoodieKeys(baseFile).stream().map(entry -> Pair.of(entry, new HoodieRecordLocation(commitTime, fileId)));
    }

    public Stream<Pair<String, HoodieRecordGlobalLocation>> globalLocations() {
        HoodieBaseFile baseFile = this.partitionPathBaseFilePair.getRight();
        return this.fetchHoodieKeys(baseFile).stream().map(entry -> Pair.of(entry.getRecordKey(), new HoodieRecordGlobalLocation(entry.getPartitionPath(), baseFile.getCommitTime(), baseFile.getFileId())));
    }
}

