/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.io.storage.HoodieAvroHFileWriter;
import org.apache.hudi.io.storage.HoodieAvroOrcWriter;
import org.apache.hudi.io.storage.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.HoodieParquetStreamWriter;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.orc.CompressionKind;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class HoodieAvroFileWriterFactory
extends HoodieFileWriterFactory {
    @Override
    protected HoodieFileWriter newParquetFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        boolean populateMetaFields;
        boolean enableBloomFilter = populateMetaFields = config.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
        HoodieAvroWriteSupport writeSupport = this.getHoodieAvroWriteSupport(conf, schema, config, enableBloomFilter);
        String compressionCodecName = config.getStringOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
        if (compressionCodecName.isEmpty()) {
            compressionCodecName = null;
        }
        HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig = new HoodieParquetConfig<HoodieAvroWriteSupport>(writeSupport, CompressionCodecName.fromConf((String)compressionCodecName), config.getIntOrDefault(HoodieStorageConfig.PARQUET_BLOCK_SIZE), config.getIntOrDefault(HoodieStorageConfig.PARQUET_PAGE_SIZE), config.getLongOrDefault(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), conf, config.getDoubleOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBooleanOrDefault(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        return new HoodieAvroParquetWriter(path, parquetConfig, instantTime, taskContextSupplier, populateMetaFields);
    }

    @Override
    protected HoodieFileWriter newParquetFileWriter(FSDataOutputStream outputStream, Configuration conf, HoodieConfig config, Schema schema) throws IOException {
        HoodieAvroWriteSupport writeSupport = this.getHoodieAvroWriteSupport(conf, schema, config, false);
        HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig = new HoodieParquetConfig<HoodieAvroWriteSupport>(writeSupport, CompressionCodecName.fromConf((String)config.getString(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME)), config.getInt(HoodieStorageConfig.PARQUET_BLOCK_SIZE), config.getInt(HoodieStorageConfig.PARQUET_PAGE_SIZE), config.getLong(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), conf, config.getDouble(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBoolean(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        return new HoodieParquetStreamWriter(outputStream, parquetConfig);
    }

    @Override
    protected HoodieFileWriter newHFileFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = this.createBloomFilter(config);
        HoodieHFileConfig hfileConfig = new HoodieHFileConfig(conf, Compression.Algorithm.valueOf(config.getString(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME)), config.getInt(HoodieStorageConfig.HFILE_BLOCK_SIZE), config.getLong(HoodieStorageConfig.HFILE_MAX_FILE_SIZE), "key", false, false, true, filter, HoodieHFileConfig.HFILE_COMPARATOR);
        return new HoodieAvroHFileWriter(instantTime, path, hfileConfig, schema, taskContextSupplier, config.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS));
    }

    @Override
    protected HoodieFileWriter newOrcFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = this.createBloomFilter(config);
        HoodieOrcConfig orcConfig = new HoodieOrcConfig(conf, CompressionKind.valueOf((String)config.getString(HoodieStorageConfig.ORC_COMPRESSION_CODEC_NAME)), config.getInt(HoodieStorageConfig.ORC_STRIPE_SIZE), config.getInt(HoodieStorageConfig.ORC_BLOCK_SIZE), config.getLong(HoodieStorageConfig.ORC_FILE_MAX_SIZE), filter);
        return new HoodieAvroOrcWriter(instantTime, path, orcConfig, schema, taskContextSupplier);
    }

    private HoodieAvroWriteSupport getHoodieAvroWriteSupport(Configuration conf, Schema schema, HoodieConfig config, boolean enableBloomFilter) {
        Option filter = enableBloomFilter ? Option.of(this.createBloomFilter(config)) : Option.empty();
        return (HoodieAvroWriteSupport)((Object)ReflectionUtils.loadClass(config.getStringOrDefault(HoodieStorageConfig.HOODIE_AVRO_WRITE_SUPPORT_CLASS), new Class[]{MessageType.class, Schema.class, Option.class, Properties.class}, new Object[]{new AvroSchemaConverter(conf).convert(schema), schema, filter, config.getProps()}));
    }
}

