/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.parser.BaseHoodieDateTimeParser;

public class KeyGenUtils {
    protected static final String NULL_RECORDKEY_PLACEHOLDER = "__null__";
    protected static final String EMPTY_RECORDKEY_PLACEHOLDER = "__empty__";
    protected static final String HUDI_DEFAULT_PARTITION_PATH = "__HIVE_DEFAULT_PARTITION__";
    public static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    public static final String DEFAULT_RECORD_KEY_PARTS_SEPARATOR = ",";
    public static final String DEFAULT_COMPOSITE_KEY_FILED_VALUE = ":";
    public static final String RECORD_KEY_GEN_PARTITION_ID_CONFIG = "_hoodie.record.key.gen.partition.id";
    public static final String RECORD_KEY_GEN_INSTANT_TIME_CONFIG = "_hoodie.record.key.gen.instant.time";

    public static KeyGeneratorType inferKeyGeneratorType(Option<String> recordsKeyFields, String partitionFields) {
        boolean autoGenerateRecordKeys;
        boolean bl = autoGenerateRecordKeys = !recordsKeyFields.isPresent();
        if (autoGenerateRecordKeys) {
            return KeyGenUtils.inferKeyGeneratorTypeForAutoKeyGen(partitionFields);
        }
        if (!StringUtils.isNullOrEmpty(partitionFields)) {
            int numPartFields = partitionFields.split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR).length;
            int numRecordKeyFields = recordsKeyFields.get().split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR).length;
            if (numPartFields == 1 && numRecordKeyFields == 1) {
                return KeyGeneratorType.SIMPLE;
            }
            return KeyGeneratorType.COMPLEX;
        }
        return KeyGeneratorType.NON_PARTITION;
    }

    private static KeyGeneratorType inferKeyGeneratorTypeForAutoKeyGen(String partitionFields) {
        if (!StringUtils.isNullOrEmpty(partitionFields)) {
            int numPartFields = partitionFields.split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR).length;
            if (numPartFields == 1) {
                return KeyGeneratorType.SIMPLE;
            }
            return KeyGeneratorType.COMPLEX;
        }
        return KeyGeneratorType.NON_PARTITION;
    }

    public static String getRecordKeyFromGenericRecord(GenericRecord genericRecord, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return keyGeneratorOpt.isPresent() ? keyGeneratorOpt.get().getRecordKey(genericRecord) : genericRecord.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
    }

    public static String getPartitionPathFromGenericRecord(GenericRecord genericRecord, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return keyGeneratorOpt.isPresent() ? keyGeneratorOpt.get().getPartitionPath(genericRecord) : genericRecord.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
    }

    public static String[] extractRecordKeys(String recordKey) {
        return KeyGenUtils.extractRecordKeysByFields(recordKey, Collections.emptyList());
    }

    public static String[] extractRecordKeysByFields(String recordKey, List<String> fields) {
        String[] fieldKV = recordKey.split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR);
        return (String[])Arrays.stream(fieldKV).map(kv -> kv.split(DEFAULT_COMPOSITE_KEY_FILED_VALUE, 2)).filter(kvArray -> ((String[])kvArray).length == 1 || fields.isEmpty() || fields.contains(kvArray[0])).map(kvArray -> {
            if (((String[])kvArray).length == 1) {
                return kvArray[0];
            }
            if (kvArray[1].equals(NULL_RECORDKEY_PLACEHOLDER)) {
                return null;
            }
            if (kvArray[1].equals(EMPTY_RECORDKEY_PLACEHOLDER)) {
                return "";
            }
            return kvArray[1];
        }).toArray(String[]::new);
    }

    public static String getRecordKey(GenericRecord record, List<String> recordKeyFields, boolean consistentLogicalTimestampEnabled) {
        boolean keyIsNullEmpty = true;
        StringBuilder recordKey = new StringBuilder();
        for (String recordKeyField : recordKeyFields) {
            String recordKeyValue = HoodieAvroUtils.getNestedFieldValAsString(record, recordKeyField, true, consistentLogicalTimestampEnabled);
            if (recordKeyValue == null) {
                recordKey.append(recordKeyField + DEFAULT_COMPOSITE_KEY_FILED_VALUE + NULL_RECORDKEY_PLACEHOLDER + DEFAULT_RECORD_KEY_PARTS_SEPARATOR);
                continue;
            }
            if (recordKeyValue.isEmpty()) {
                recordKey.append(recordKeyField + DEFAULT_COMPOSITE_KEY_FILED_VALUE + EMPTY_RECORDKEY_PLACEHOLDER + DEFAULT_RECORD_KEY_PARTS_SEPARATOR);
                continue;
            }
            recordKey.append(recordKeyField + DEFAULT_COMPOSITE_KEY_FILED_VALUE + recordKeyValue + DEFAULT_RECORD_KEY_PARTS_SEPARATOR);
            keyIsNullEmpty = false;
        }
        recordKey.deleteCharAt(recordKey.length() - 1);
        if (keyIsNullEmpty) {
            throw new HoodieKeyException("recordKey values: \"" + recordKey + "\" for fields: " + recordKeyFields.toString() + " cannot be entirely null or empty.");
        }
        return recordKey.toString();
    }

    public static String getRecordPartitionPath(GenericRecord record, List<String> partitionPathFields, boolean hiveStylePartitioning, boolean encodePartitionPath, boolean consistentLogicalTimestampEnabled) {
        if (partitionPathFields.isEmpty()) {
            return "";
        }
        StringBuilder partitionPath = new StringBuilder();
        for (String partitionPathField : partitionPathFields) {
            String fieldVal = HoodieAvroUtils.getNestedFieldValAsString(record, partitionPathField, true, consistentLogicalTimestampEnabled);
            if (fieldVal == null || fieldVal.isEmpty()) {
                partitionPath.append(hiveStylePartitioning ? partitionPathField + "=" + HUDI_DEFAULT_PARTITION_PATH : HUDI_DEFAULT_PARTITION_PATH);
            } else {
                if (encodePartitionPath) {
                    fieldVal = PartitionPathEncodeUtils.escapePathName(fieldVal);
                }
                partitionPath.append(hiveStylePartitioning ? partitionPathField + "=" + fieldVal : fieldVal);
            }
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        partitionPath.deleteCharAt(partitionPath.length() - 1);
        return partitionPath.toString();
    }

    public static String getRecordKey(GenericRecord record, String recordKeyField, boolean consistentLogicalTimestampEnabled) {
        String recordKey = HoodieAvroUtils.getNestedFieldValAsString(record, recordKeyField, true, consistentLogicalTimestampEnabled);
        if (recordKey == null || recordKey.isEmpty()) {
            throw new HoodieKeyException("recordKey value: \"" + recordKey + "\" for field: \"" + recordKeyField + "\" cannot be null or empty.");
        }
        return recordKey;
    }

    public static String getPartitionPath(GenericRecord record, String partitionPathField, boolean hiveStylePartitioning, boolean encodePartitionPath, boolean consistentLogicalTimestampEnabled) {
        String partitionPath = HoodieAvroUtils.getNestedFieldValAsString(record, partitionPathField, true, consistentLogicalTimestampEnabled);
        if (partitionPath == null || partitionPath.isEmpty()) {
            partitionPath = HUDI_DEFAULT_PARTITION_PATH;
        }
        if (encodePartitionPath) {
            partitionPath = PartitionPathEncodeUtils.escapePathName(partitionPath);
        }
        if (hiveStylePartitioning) {
            partitionPath = partitionPathField + "=" + partitionPath;
        }
        return partitionPath;
    }

    public static BaseHoodieDateTimeParser createDateTimeParser(TypedProperties props, String parserClass) throws IOException {
        try {
            return (BaseHoodieDateTimeParser)ReflectionUtils.loadClass(parserClass, props);
        }
        catch (Throwable e) {
            throw new IOException("Could not load date time parser class " + parserClass, e);
        }
    }

    public static KeyGenerator createKeyGeneratorByClassName(TypedProperties props) throws IOException {
        KeyGenerator keyGenerator = null;
        String keyGeneratorClass = props.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), null);
        if (!StringUtils.isNullOrEmpty(keyGeneratorClass)) {
            try {
                keyGenerator = (KeyGenerator)ReflectionUtils.loadClass(keyGeneratorClass, props);
            }
            catch (Throwable e) {
                throw new IOException("Could not load key generator class " + keyGeneratorClass, e);
            }
        }
        return keyGenerator;
    }

    public static List<String> getRecordKeyFields(TypedProperties props) {
        return Option.ofNullable(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)).map(recordKeyConfigValue -> Arrays.stream(recordKeyConfigValue.split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static boolean enableAutoGenerateRecordKeys(TypedProperties props) {
        return !props.containsKey(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key());
    }
}

