/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieSerializableFileStatus;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.expression.BindVisitor;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.PartialBindVisitor;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.metadata.AbstractHoodieTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataPartitionType;

public class FileSystemBackedTableMetadata
extends AbstractHoodieTableMetadata {
    private static final int DEFAULT_LISTING_PARALLELISM = 1500;
    private final boolean assumeDatePartitioning;
    private final boolean hiveStylePartitioningEnabled;
    private final boolean urlEncodePartitioningEnabled;

    public FileSystemBackedTableMetadata(HoodieEngineContext engineContext, HoodieTableConfig tableConfig, SerializableConfiguration conf, String datasetBasePath, boolean assumeDatePartitioning) {
        super(engineContext, conf, datasetBasePath);
        this.hiveStylePartitioningEnabled = Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable());
        this.urlEncodePartitioningEnabled = Boolean.parseBoolean(tableConfig.getUrlEncodePartitioning());
        this.assumeDatePartitioning = assumeDatePartitioning;
    }

    public FileSystemBackedTableMetadata(HoodieEngineContext engineContext, SerializableConfiguration conf, String datasetBasePath, boolean assumeDatePartitioning) {
        super(engineContext, conf, datasetBasePath);
        FileSystem fs = FSUtils.getFs(this.dataBasePath.get(), conf.get());
        Path metaPath = new Path(this.dataBasePath.get(), ".hoodie");
        TableNotFoundException.checkTableValidity(fs, this.dataBasePath.get(), metaPath);
        HoodieTableConfig tableConfig = new HoodieTableConfig(fs, metaPath.toString(), null, null);
        this.hiveStylePartitioningEnabled = Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable());
        this.urlEncodePartitioningEnabled = Boolean.parseBoolean(tableConfig.getUrlEncodePartitioning());
        this.assumeDatePartitioning = assumeDatePartitioning;
    }

    @Override
    public FileStatus[] getAllFilesInPartition(Path partitionPath) throws IOException {
        FileSystem fs = partitionPath.getFileSystem(this.hadoopConf.get());
        return FSUtils.getAllDataFilesInPartition(fs, partitionPath);
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        Path basePath = this.dataBasePath.get();
        if (this.assumeDatePartitioning) {
            FileSystem fs = basePath.getFileSystem(this.hadoopConf.get());
            return FSUtils.getAllPartitionFoldersThreeLevelsDown(fs, this.dataBasePath.toString());
        }
        return this.getPartitionPathWithPathPrefixes(Collections.singletonList(""));
    }

    @Override
    public List<String> getPartitionPathWithPathPrefixUsingFilterExpression(List<String> relativePathPrefixes, Types.RecordType partitionFields, Expression expression) throws IOException {
        return relativePathPrefixes.stream().flatMap(relativePathPrefix -> {
            try {
                return this.getPartitionPathWithPathPrefixUsingFilterExpression((String)relativePathPrefix, partitionFields, expression).stream();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error fetching partition paths with relative path: " + relativePathPrefix, e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> getPartitionPathWithPathPrefixes(List<String> relativePathPrefixes) {
        return relativePathPrefixes.stream().flatMap(relativePathPrefix -> {
            try {
                return this.getPartitionPathWithPathPrefix((String)relativePathPrefix).stream();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error fetching partition paths with relative path: " + relativePathPrefix, e);
            }
        }).collect(Collectors.toList());
    }

    private List<String> getPartitionPathWithPathPrefix(String relativePathPrefix) throws IOException {
        return this.getPartitionPathWithPathPrefixUsingFilterExpression(relativePathPrefix, null, null);
    }

    private List<String> getPartitionPathWithPathPrefixUsingFilterExpression(String relativePathPrefix, Types.RecordType partitionFields, Expression pushedExpr) throws IOException {
        Expression fullBoundExpr;
        boolean needPushDownExpressions;
        CopyOnWriteArrayList<Path> pathsToList = new CopyOnWriteArrayList<Path>();
        pathsToList.add(StringUtils.isNullOrEmpty(relativePathPrefix) ? this.dataBasePath.get() : new Path(this.dataBasePath.get(), relativePathPrefix));
        CopyOnWriteArrayList<String> partitionPaths = new CopyOnWriteArrayList<String>();
        int currentPartitionLevel = -1;
        if (this.hiveStylePartitioningEnabled && this.urlEncodePartitioningEnabled && pushedExpr != null && partitionFields != null) {
            currentPartitionLevel = FileSystemBackedTableMetadata.getPathPartitionLevel(partitionFields, relativePathPrefix);
            needPushDownExpressions = true;
            fullBoundExpr = pushedExpr.accept(new BindVisitor(partitionFields, false));
        } else {
            fullBoundExpr = Predicates.alwaysTrue();
            needPushDownExpressions = false;
        }
        while (!pathsToList.isEmpty()) {
            Expression partialBoundExpr;
            int listingParallelism = Math.min(1500, pathsToList.size());
            this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Listing all partitions with prefix " + relativePathPrefix);
            List dirToFileListing = this.engineContext.flatMap(pathsToList, path -> {
                FileSystem fileSystem2 = path.getFileSystem(this.hadoopConf.get());
                return Arrays.stream(HoodieSerializableFileStatus.fromFileStatuses(fileSystem2.listStatus(path)));
            }, listingParallelism);
            pathsToList.clear();
            int fileListingParallelism = Math.min(1500, dirToFileListing.size());
            if (dirToFileListing.isEmpty()) continue;
            this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Processing listed partitions");
            List<Pair> result = this.engineContext.map(dirToFileListing, fileStatus -> {
                Path path = fileStatus.getPath();
                FileSystem fileSystem2 = path.getFileSystem(this.hadoopConf.get());
                if (fileStatus.isDirectory().booleanValue()) {
                    if (HoodiePartitionMetadata.hasPartitionMetadata(fileSystem2, path)) {
                        return Pair.of(Option.of(FSUtils.getRelativePartitionPath(this.dataBasePath.get(), path)), Option.empty());
                    }
                    if (!path.getName().equals(".hoodie")) {
                        return Pair.of(Option.empty(), Option.of(path));
                    }
                } else if (path.getName().startsWith(".hoodie_partition_metadata")) {
                    String partitionName = FSUtils.getRelativePartitionPath(this.dataBasePath.get(), path.getParent());
                    return Pair.of(Option.of(partitionName), Option.empty());
                }
                return Pair.of(Option.empty(), Option.empty());
            }, fileListingParallelism);
            partitionPaths.addAll(result.stream().filter(entry -> ((Option)entry.getKey()).isPresent()).map(entry -> (String)((Option)entry.getKey()).get()).filter(relativePartitionPath -> fullBoundExpr instanceof Predicates.TrueExpression || (Boolean)fullBoundExpr.eval(FileSystemBackedTableMetadata.extractPartitionValues(partitionFields, relativePartitionPath, this.urlEncodePartitioningEnabled)) != false).collect(Collectors.toList()));
            if (needPushDownExpressions && partitionPaths.isEmpty()) {
                Types.RecordType currentSchema = Types.RecordType.get(partitionFields.fields().subList(0, ++currentPartitionLevel));
                PartialBindVisitor partialBindVisitor = new PartialBindVisitor(currentSchema, false);
                partialBoundExpr = pushedExpr.accept(partialBindVisitor);
            } else {
                partialBoundExpr = Predicates.alwaysTrue();
            }
            pathsToList.addAll(result.stream().filter(entry -> ((Option)entry.getValue()).isPresent()).map(entry -> (Path)((Option)entry.getValue()).get()).filter(path -> partialBoundExpr instanceof Predicates.TrueExpression || (Boolean)partialBoundExpr.eval(FileSystemBackedTableMetadata.extractPartitionValues(partitionFields, FSUtils.getRelativePartitionPath(this.dataBasePath.get(), path), this.urlEncodePartitioningEnabled)) != false).collect(Collectors.toList()));
        }
        return partitionPaths;
    }

    @Override
    public Map<String, FileStatus[]> getAllFilesInPartitions(Collection<String> partitionPaths) throws IOException {
        if (partitionPaths == null || partitionPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        int parallelism = Math.min(1500, partitionPaths.size());
        this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Listing all files in " + partitionPaths.size() + " partitions");
        List<Pair> partitionToFiles = this.engineContext.map(new ArrayList<String>(partitionPaths), partitionPathStr -> {
            Path partitionPath = new Path(partitionPathStr);
            FileSystem fs = partitionPath.getFileSystem(this.hadoopConf.get());
            return Pair.of(partitionPathStr, HoodieSerializableFileStatus.fromFileStatuses(FSUtils.getAllDataFilesInPartition(fs, partitionPath)));
        }, parallelism);
        return partitionToFiles.stream().collect(Collectors.toMap(Pair::getLeft, pair -> HoodieSerializableFileStatus.toFileStatuses((HoodieSerializableFileStatus[])pair.getRight())));
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<String> getLatestCompactionTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void reset() {
    }

    @Override
    public Option<BloomFilter> getBloomFilter(String partitionName, String fileName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilter for " + fileName);
    }

    @Override
    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> partitionNameFileNameList) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilters!");
    }

    @Override
    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, String columnName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getColumnsStats!");
    }

    @Override
    public HoodieData<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> keyPrefixes, String partitionName, boolean shouldLoadInMemory) {
        throw new HoodieMetadataException("Unsupported operation: getRecordsByKeyPrefixes!");
    }

    @Override
    public Map<String, HoodieRecordGlobalLocation> readRecordIndex(List<String> recordKeys) {
        throw new HoodieMetadataException("Unsupported operation: readRecordIndex!");
    }

    @Override
    public int getNumFileGroupsForPartition(MetadataPartitionType partition) {
        throw new HoodieMetadataException("Unsupported operation: getNumFileGroupsForPartition");
    }
}

