/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client.coprocessor;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class LongColumnInterpreter
extends ColumnInterpreter<Long, Long, HBaseProtos.EmptyMsg, HBaseProtos.LongMsg, HBaseProtos.LongMsg> {
    @Override
    public Long getValue(byte[] colFamily, byte[] colQualifier, Cell kv) throws IOException {
        if (kv == null || kv.getValueLength() != 8) {
            return null;
        }
        return PrivateCellUtil.getValueAsLong(kv);
    }

    @Override
    public Long add(Long l1, Long l2) {
        if (l1 == null ^ l2 == null) {
            return l1 == null ? l2 : l1;
        }
        if (l1 == null) {
            return null;
        }
        return l1 + l2;
    }

    @Override
    public int compare(Long l1, Long l2) {
        if (l1 == null ^ l2 == null) {
            return l1 == null ? -1 : 1;
        }
        if (l1 == null) {
            return 0;
        }
        return l1.compareTo(l2);
    }

    @Override
    public Long getMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public Long increment(Long o) {
        return o == null ? null : Long.valueOf(o + 1L);
    }

    @Override
    public Long multiply(Long l1, Long l2) {
        return l1 == null || l2 == null ? null : Long.valueOf(l1 * l2);
    }

    @Override
    public Long getMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    public double divideForAvg(Long l1, Long l2) {
        return l2 == null || l1 == null ? Double.NaN : l1.doubleValue() / l2.doubleValue();
    }

    @Override
    public Long castToReturnType(Long o) {
        return o;
    }

    @Override
    public Long castToCellType(Long l) {
        return l;
    }

    @Override
    public HBaseProtos.EmptyMsg getRequestData() {
        return HBaseProtos.EmptyMsg.getDefaultInstance();
    }

    @Override
    public void initialize(HBaseProtos.EmptyMsg msg) {
    }

    @Override
    public HBaseProtos.LongMsg getProtoForCellType(Long t) {
        HBaseProtos.LongMsg.Builder builder = HBaseProtos.LongMsg.newBuilder();
        return builder.setLongMsg(t).build();
    }

    @Override
    public HBaseProtos.LongMsg getProtoForPromotedType(Long s) {
        HBaseProtos.LongMsg.Builder builder = HBaseProtos.LongMsg.newBuilder();
        return builder.setLongMsg(s).build();
    }

    @Override
    public Long getPromotedValueFromProto(HBaseProtos.LongMsg r) {
        return r.getLongMsg();
    }

    @Override
    public Long getCellValueFromProto(HBaseProtos.LongMsg q) {
        return q.getLongMsg();
    }
}

