/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class QuotaFilter {
    private Set<QuotaType> types = new HashSet<QuotaType>();
    private boolean hasFilters = false;
    private String namespaceRegex;
    private String tableRegex;
    private String userRegex;
    private String regionServerRegex;

    public QuotaFilter setUserFilter(String regex2) {
        this.userRegex = regex2;
        this.hasFilters |= StringUtils.isNotEmpty((CharSequence)regex2);
        return this;
    }

    public QuotaFilter setTableFilter(String regex2) {
        this.tableRegex = regex2;
        this.hasFilters |= StringUtils.isNotEmpty((CharSequence)regex2);
        return this;
    }

    public QuotaFilter setNamespaceFilter(String regex2) {
        this.namespaceRegex = regex2;
        this.hasFilters |= StringUtils.isNotEmpty((CharSequence)regex2);
        return this;
    }

    public QuotaFilter setRegionServerFilter(String regex2) {
        this.regionServerRegex = regex2;
        this.hasFilters |= StringUtils.isNotEmpty((CharSequence)regex2);
        return this;
    }

    public QuotaFilter addTypeFilter(QuotaType type) {
        this.types.add(type);
        this.hasFilters |= true;
        return this;
    }

    public boolean isNull() {
        return !this.hasFilters;
    }

    public Set<QuotaType> getTypeFilters() {
        return this.types;
    }

    public String getNamespaceFilter() {
        return this.namespaceRegex;
    }

    public String getTableFilter() {
        return this.tableRegex;
    }

    public String getUserFilter() {
        return this.userRegex;
    }

    public String getRegionServerFilter() {
        return this.regionServerRegex;
    }
}

