/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.hudi.org.eclipse.jetty.util.LazyList;
import org.apache.hudi.org.eclipse.jetty.util.Loader;
import org.apache.hudi.org.eclipse.jetty.util.MultiException;
import org.apache.hudi.org.eclipse.jetty.util.Pool;
import org.apache.hudi.org.eclipse.jetty.util.StringUtil;
import org.apache.hudi.org.eclipse.jetty.util.TypeUtil;
import org.apache.hudi.org.eclipse.jetty.util.annotation.Name;
import org.apache.hudi.org.eclipse.jetty.util.component.LifeCycle;
import org.apache.hudi.org.eclipse.jetty.util.log.Log;
import org.apache.hudi.org.eclipse.jetty.util.log.Logger;
import org.apache.hudi.org.eclipse.jetty.util.resource.Resource;
import org.apache.hudi.org.eclipse.jetty.xml.ConfigurationProcessor;
import org.apache.hudi.org.eclipse.jetty.xml.ConfigurationProcessorFactory;
import org.apache.hudi.org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static final Logger LOG = Log.getLogger(XmlConfiguration.class);
    private static final Class<?>[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] __boxedPrimitives = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Class<?>[] __supportedCollections = new Class[]{ArrayList.class, HashSet.class, Queue.class, List.class, Set.class, Collection.class};
    private static final Iterable<ConfigurationProcessorFactory> __factoryLoader = ServiceLoader.load(ConfigurationProcessorFactory.class);
    private static final Pool<ConfigurationParser> __parsers = new Pool(Pool.StrategyType.THREAD_ID, Math.min(8, Runtime.getRuntime().availableProcessors()));
    public static final Comparator<Executable> EXECUTABLE_COMPARATOR = (e1, e2) -> {
        int count = e1.getParameterCount();
        int compare = Integer.compare(count, e2.getParameterCount());
        if (compare == 0 && count > 0) {
            Parameter[] p1 = e1.getParameters();
            Parameter[] p2 = e2.getParameters();
            compare = Boolean.compare(p1[count - 1].isVarArgs(), p2[count - 1].isVarArgs());
            if (compare == 0) {
                for (int i = 0; i < count; ++i) {
                    Class<?> t2;
                    Class<?> t1 = p1[i].getType();
                    if (t1 == (t2 = p2[i].getType())) continue;
                    compare = Boolean.compare(t1.isAssignableFrom(t2), t2.isAssignableFrom(t1));
                    if (compare == 0 && (compare = Boolean.compare(!t1.isPrimitive(), !t2.isPrimitive())) == 0) {
                        compare = t1.getName().compareTo(t2.getName());
                    }
                    if (compare != 0) break;
                }
            }
            compare = Math.min(1, Math.max(compare, -1));
        }
        return compare;
    };
    private final Map<String, Object> _idMap = new HashMap<String, Object>();
    private final Map<String, String> _propertyMap = new HashMap<String, String>();
    private final Resource _location;
    private final String _dtd;
    private ConfigurationProcessor _processor;

    public void setJettyStandardIdsAndProperties(Object server, Resource webapp) {
        try {
            if (server != null) {
                this.getIdMap().put("Server", server);
            }
            Path home = Paths.get(System.getProperty("jetty.home", "."), new String[0]);
            this.getProperties().put("jetty.home", home.toString());
            this.getProperties().put("jetty.home.uri", XmlConfiguration.normalizeURI(home.toUri().toASCIIString()));
            Path base = Paths.get(System.getProperty("jetty.base", home.toString()), new String[0]);
            this.getProperties().put("jetty.base", base.toString());
            this.getProperties().put("jetty.base.uri", XmlConfiguration.normalizeURI(base.toUri().toASCIIString()));
            if (webapp != null) {
                Path webappPath = webapp.getFile().toPath().toAbsolutePath();
                this.getProperties().put("jetty.webapp", webappPath.toString());
                this.getProperties().put("jetty.webapps", webappPath.getParent().toString());
                this.getProperties().put("jetty.webapps.uri", XmlConfiguration.normalizeURI(webapp.getURI().toString()));
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    public static String normalizeURI(String uri2) {
        if (uri2.endsWith("/")) {
            return uri2.substring(0, uri2.length() - 1);
        }
        return uri2;
    }

    ConfigurationParser getParser() {
        Pool.Entry entry = __parsers.acquire(x$0 -> new ConfigurationParser((Pool.Entry)x$0));
        if (entry == null) {
            return new ConfigurationParser(null);
        }
        return (ConfigurationParser)entry.getPooled();
    }

    public XmlConfiguration(Resource resource) throws SAXException, IOException {
        try (ConfigurationParser parser = this.getParser();
             InputStream inputStream = resource.getInputStream();){
            this._location = resource;
            this.setConfig(parser.parse(inputStream));
            this._dtd = parser.getDTD();
        }
    }

    @Deprecated
    public XmlConfiguration(URL configuration) throws SAXException, IOException {
        this(Resource.newResource(configuration));
    }

    @Deprecated
    public XmlConfiguration(String configuration) throws SAXException, IOException {
        configuration = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"http://www.eclipse.org/jetty/configure_9_3.dtd\">" + configuration;
        try (ConfigurationParser parser = this.getParser();
             StringReader reader = new StringReader(configuration);){
            InputSource source = new InputSource(reader);
            this._location = null;
            this.setConfig(parser.parse(source));
            this._dtd = parser.getDTD();
        }
    }

    @Deprecated
    public XmlConfiguration(InputStream configuration) throws SAXException, IOException {
        InputSource source = new InputSource(configuration);
        try (ConfigurationParser parser = this.getParser();){
            this._location = null;
            this.setConfig(parser.parse(source));
            this._dtd = parser.getDTD();
        }
    }

    public String toString() {
        if (this._location == null) {
            return "UNKNOWN-LOCATION";
        }
        return this._location.toString();
    }

    private void setConfig(XmlParser.Node config) {
        if ("Configure".equals(config.getTag())) {
            this._processor = new JettyXmlConfiguration();
        } else if (__factoryLoader != null) {
            for (ConfigurationProcessorFactory factory : __factoryLoader) {
                this._processor = factory.getConfigurationProcessor(this._dtd, config.getTag());
                if (this._processor == null) continue;
                break;
            }
            if (this._processor == null) {
                throw new IllegalStateException("Unknown configuration type: " + config.getTag() + " in " + this);
            }
        } else {
            throw new IllegalArgumentException("Unknown XML tag:" + config.getTag());
        }
        this._processor.init(this._location, config, this);
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }

    public Map<String, String> getProperties() {
        return this._propertyMap;
    }

    public Object configure(Object obj) throws Exception {
        return this._processor.configure(obj);
    }

    public Object configure() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configure {}", this._location);
        }
        return this._processor.configure();
    }

    public void initializeDefaults(Object object) {
    }

    private static List<XmlParser.Node> getNodes(XmlParser.Node node, String elementName) {
        XmlParser.Node n;
        String attrName = StringUtil.asciiToLowerCase(elementName);
        ArrayList<XmlParser.Node> values2 = new ArrayList<XmlParser.Node>();
        String attr = node.getAttribute(attrName);
        if (attr != null) {
            for (String a : StringUtil.csvSplit(null, attr, 0, attr.length())) {
                n = new XmlParser.Node(null, elementName, null);
                n.add(a);
                values2.add(n);
            }
        }
        for (Object o : node) {
            if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
            if (attr != null) {
                throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
            }
            values2.add(n);
        }
        return values2;
    }

    public static void main(String ... args2) throws Exception {
        try {
            AccessController.doPrivileged(() -> {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)System.getProperties());
                for (String string : args2) {
                    if (string.indexOf(61) >= 0) {
                        int i = string.indexOf(61);
                        properties.put(string.substring(0, i), string.substring(i + 1));
                        continue;
                    }
                    if (!string.toLowerCase(Locale.ENGLISH).endsWith(".properties")) continue;
                    properties.load(Resource.newResource(string).getInputStream());
                }
                XmlConfiguration last = null;
                ArrayList<Object> objects = new ArrayList<Object>(args2.length);
                for (String arg : args2) {
                    Object obj;
                    if (arg.toLowerCase(Locale.ENGLISH).endsWith(".properties") || arg.indexOf(61) >= 0) continue;
                    XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(arg));
                    if (last != null) {
                        configuration.getIdMap().putAll(last.getIdMap());
                    }
                    if (properties.size() > 0) {
                        HashMap props = new HashMap();
                        properties.entrySet().stream().forEach(objectObjectEntry -> props.put(objectObjectEntry.getKey().toString(), String.valueOf(objectObjectEntry.getValue())));
                        configuration.getProperties().putAll(props);
                    }
                    if ((obj = configuration.configure()) != null && !objects.contains(obj)) {
                        objects.add(obj);
                    }
                    last = configuration;
                }
                for (Object e : objects) {
                    LifeCycle lc;
                    if (!(e instanceof LifeCycle) || (lc = (LifeCycle)e).isRunning()) continue;
                    lc.start();
                }
                return null;
            });
        }
        catch (Error | Exception e) {
            LOG.warn(e);
            throw e;
        }
    }

    private static class ConfigurationParser
    extends XmlParser
    implements AutoCloseable {
        private final Pool.Entry _entry;

        private ConfigurationParser(Pool.Entry entry) {
            this._entry = entry;
            ClassLoader loader = XmlConfiguration.class.getClassLoader();
            URL config60 = loader.getResource("org/apache/hudi/org/eclipse/jetty/xml/configure_6_0.dtd");
            URL config76 = loader.getResource("org/apache/hudi/org/eclipse/jetty/xml/configure_7_6.dtd");
            URL config90 = loader.getResource("org/apache/hudi/org/eclipse/jetty/xml/configure_9_0.dtd");
            URL config93 = loader.getResource("org/apache/hudi/org/eclipse/jetty/xml/configure_9_3.dtd");
            this.redirectEntity("configure.dtd", config90);
            this.redirectEntity("configure_1_0.dtd", config60);
            this.redirectEntity("configure_1_1.dtd", config60);
            this.redirectEntity("configure_1_2.dtd", config60);
            this.redirectEntity("configure_1_3.dtd", config60);
            this.redirectEntity("configure_6_0.dtd", config60);
            this.redirectEntity("configure_7_6.dtd", config76);
            this.redirectEntity("configure_9_0.dtd", config90);
            this.redirectEntity("configure_9_3.dtd", config93);
            this.redirectEntity("http://jetty.mortbay.org/configure.dtd", config93);
            this.redirectEntity("http://jetty.eclipse.org/configure.dtd", config93);
            this.redirectEntity("https://jetty.eclipse.org/configure.dtd", config93);
            this.redirectEntity("http://www.eclipse.org/jetty/configure.dtd", config93);
            this.redirectEntity("https://www.eclipse.org/jetty/configure.dtd", config93);
            this.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", config93);
            this.redirectEntity("-//Jetty//Configure//EN", config93);
        }

        @Override
        public void close() {
            if (this._entry != null) {
                __parsers.release(this._entry);
            }
        }
    }

    private static class JettyXmlConfiguration
    implements ConfigurationProcessor {
        XmlParser.Node _root;
        XmlConfiguration _configuration;

        private JettyXmlConfiguration() {
        }

        @Override
        public void init(URL url2, XmlParser.Node root, XmlConfiguration configuration) {
        }

        @Override
        public void init(Resource resource, XmlParser.Node root, XmlConfiguration configuration) {
            this._root = root;
            this._configuration = configuration;
        }

        @Override
        public Object configure(Object obj) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._root);
            if (oClass != null && !oClass.isInstance(obj)) {
                String loaders = oClass.getClassLoader() == obj.getClass().getClassLoader() ? "" : "Object Class and type Class are from different loaders.";
                throw new IllegalArgumentException("Object of class '" + obj.getClass().getCanonicalName() + "' is not of type '" + oClass.getCanonicalName() + "'. " + loaders + " in " + this._configuration);
            }
            String id = this._root.getAttribute("id");
            if (id != null) {
                this._configuration.getIdMap().put(id, obj);
            }
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, this._root, "Arg");
            aoeNode.getNodes("Arg").forEach(node -> LOG.warn("Ignored arg {} in {}", node, this._configuration._location));
            this.configure(obj, this._root, aoeNode.getNext());
            return obj;
        }

        @Override
        public Object configure() throws Exception {
            AttrOrElementNode aoeNode;
            Object obj;
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._root);
            String id = this._root.getAttribute("id");
            Object object = obj = id == null ? null : this._configuration.getIdMap().get(id);
            if (obj == null && oClass != null) {
                aoeNode = new AttrOrElementNode(this._root, "Arg");
                try {
                    obj = this.construct(oClass, new Args(null, oClass, aoeNode.getNodes("Arg")));
                }
                catch (NoSuchMethodException x) {
                    throw new IllegalStateException(String.format("No matching constructor %s in %s", oClass, this._configuration));
                }
            } else {
                aoeNode = new AttrOrElementNode(obj, this._root, "Arg");
                aoeNode.getNodes("Arg").forEach(node -> LOG.warn("Ignored arg {} in {}", node, this._configuration._location));
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, obj);
            }
            this._configuration.initializeDefaults(obj);
            this.configure(obj, this._root, aoeNode.getNext());
            return obj;
        }

        private static Class<?> nodeClass(XmlParser.Node node) throws ClassNotFoundException {
            String className = node.getAttribute("class");
            if (className == null) {
                return null;
            }
            return Loader.loadClass(className);
        }

        public void configure(Object obj, XmlParser.Node cfg, int i) throws Exception {
            while (i < cfg.size()) {
                Object o = cfg.get(i);
                if (!(o instanceof String)) {
                    XmlParser.Node node = (XmlParser.Node)o;
                    try {
                        String tag;
                        switch (tag = node.getTag()) {
                            case "Arg": 
                            case "Class": 
                            case "Id": {
                                throw new IllegalStateException("Element '" + tag + "' not skipped");
                            }
                            case "Set": {
                                this.set(obj, node);
                                break;
                            }
                            case "Put": {
                                this.put(obj, node);
                                break;
                            }
                            case "Call": {
                                this.call(obj, node);
                                break;
                            }
                            case "Get": {
                                this.get(obj, node);
                                break;
                            }
                            case "New": {
                                this.newObj(obj, node);
                                break;
                            }
                            case "Array": {
                                this.newArray(obj, node);
                                break;
                            }
                            case "Map": {
                                this.newMap(obj, node);
                                break;
                            }
                            case "Ref": {
                                this.refObj(node);
                                break;
                            }
                            case "Property": {
                                this.propertyObj(node);
                                break;
                            }
                            case "SystemProperty": {
                                this.systemPropertyObj(node);
                                break;
                            }
                            case "Env": {
                                this.envObj(node);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown tag: " + tag + " in " + this._configuration);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Config error at " + node, e.toString() + " in " + this._configuration);
                        throw e;
                    }
                }
                ++i;
            }
        }

        private void set(Object obj, XmlParser.Node node) throws Exception {
            boolean isUsingDefaultValue;
            String attr = node.getAttribute("name");
            String name = "set" + attr.substring(0, 1).toUpperCase(Locale.ENGLISH) + attr.substring(1);
            Object value = this.value(obj, node);
            String defaultValue = this.defaultValue(obj, node);
            Object[] arg = new Object[]{value};
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            Class[] vClass = new Class[]{Object.class};
            if (value != null) {
                vClass[0] = value.getClass();
            }
            boolean bl = isUsingDefaultValue = value != null && defaultValue.equalsIgnoreCase(value.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML {}.{}({}) [{}]", obj != null ? obj.toString() : oClass.getName(), name, value, isUsingDefaultValue ? "DEFAULT" : "NEW");
            }
            MultiException me = new MultiException();
            try {
                Method set = oClass.getMethod(name, vClass);
                this.invokeMethod(set, obj, arg, isUsingDefaultValue);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
                LOG.ignore(e);
                me.add(e);
                try {
                    Field type = vClass[0].getField("TYPE");
                    vClass[0] = (Class)type.get(null);
                    Method set = oClass.getMethod(name, vClass);
                    this.invokeMethod(set, obj, arg, isUsingDefaultValue);
                    return;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException e2) {
                    LOG.ignore(e2);
                    me.add(e2);
                    try {
                        Field field = oClass.getField(attr);
                        if (Modifier.isPublic(field.getModifiers())) {
                            try {
                                this.setField(field, obj, value, isUsingDefaultValue);
                                return;
                            }
                            catch (IllegalArgumentException e3) {
                                if (value instanceof String) {
                                    try {
                                        value = TypeUtil.valueOf(field.getType(), ((String)value).trim());
                                        this.setField(field, obj, value, isUsingDefaultValue);
                                        return;
                                    }
                                    catch (Exception e22) {
                                        e3.addSuppressed(e22);
                                        throw e3;
                                    }
                                }
                            }
                        }
                    }
                    catch (NoSuchFieldException e4) {
                        LOG.ignore(e4);
                        me.add(e4);
                    }
                    Method[] sets = oClass.getMethods();
                    Method set = null;
                    String types = null;
                    for (Method setter : sets) {
                        if (setter.getParameterCount() != 1) continue;
                        Class<?>[] paramTypes = setter.getParameterTypes();
                        if (!name.equals(setter.getName())) continue;
                        types = types == null ? paramTypes[0].getName() : types + "," + paramTypes[0].getName();
                        try {
                            set = setter;
                            this.invokeMethod(set, obj, arg, isUsingDefaultValue);
                            return;
                        }
                        catch (IllegalAccessException | IllegalArgumentException e5) {
                            LOG.ignore(e5);
                            me.add(e5);
                            try {
                                for (Class c : __supportedCollections) {
                                    if (!paramTypes[0].isAssignableFrom(c)) continue;
                                    Object[] args2 = new Object[]{JettyXmlConfiguration.convertArrayToCollection(value, c)};
                                    this.invokeMethod(setter, obj, args2, isUsingDefaultValue);
                                    return;
                                }
                            }
                            catch (IllegalAccessException e6) {
                                LOG.ignore(e6);
                                me.add(e6);
                            }
                        }
                    }
                    if (set != null) {
                        try {
                            Class sClass = set.getParameterTypes()[0];
                            if (sClass.isPrimitive()) {
                                for (int t = 0; t < __primitives.length; ++t) {
                                    if (!sClass.equals(__primitives[t])) continue;
                                    sClass = __boxedPrimitives[t];
                                    break;
                                }
                            }
                            Constructor<?> cons = sClass.getConstructor(vClass);
                            arg[0] = cons.newInstance(arg);
                            this._configuration.initializeDefaults(arg[0]);
                            this.invokeMethod(set, obj, arg, isUsingDefaultValue);
                            return;
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e7) {
                            LOG.ignore(e7);
                            me.add(e7);
                        }
                    }
                    String message = oClass + "." + name + "(" + vClass[0] + ")";
                    if (types != null) {
                        message = message + ". Found setters for " + types;
                    }
                    NoSuchMethodException failure = new NoSuchMethodException(message);
                    for (int i = 0; i < me.size(); ++i) {
                        failure.addSuppressed(me.getThrowable(i));
                    }
                    throw failure;
                }
            }
        }

        private Object invokeConstructor(Constructor<?> constructor, Object ... args2) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Object result = constructor.newInstance(args2);
            if (constructor.getAnnotation(Deprecated.class) != null) {
                LOG.warn("Deprecated constructor {} in {}", constructor, this._configuration);
            }
            return result;
        }

        private Object invokeMethod(Method method, Object obj, Object[] args2) throws IllegalAccessException, InvocationTargetException {
            return this.invokeMethod(method, obj, args2, false);
        }

        private Object invokeMethod(Method method, Object obj, Object[] args2, boolean isUsingDefaultValue) throws IllegalAccessException, InvocationTargetException {
            Object result = method.invoke(obj, args2);
            if (method.getAnnotation(Deprecated.class) != null) {
                if (isUsingDefaultValue) {
                    LOG.debug("Deprecated method {} in {}", method, this._configuration);
                } else {
                    LOG.warn("Deprecated method {} in {}", method, this._configuration);
                }
            }
            return result;
        }

        private Object getField(Field field, Object object) throws IllegalAccessException {
            Object result = field.get(object);
            if (field.getAnnotation(Deprecated.class) != null) {
                LOG.warn("Deprecated field {} in {}", field, this._configuration);
            }
            return result;
        }

        private void setField(Field field, Object obj, Object arg, boolean isUsingDefaultValue) throws IllegalAccessException {
            field.set(obj, arg);
            if (field.getAnnotation(Deprecated.class) != null) {
                if (isUsingDefaultValue) {
                    LOG.debug("Deprecated field {} in {}", field, this._configuration);
                } else {
                    LOG.warn("Deprecated field {} in {}", field, this._configuration);
                }
            }
        }

        private static Collection<?> convertArrayToCollection(Object array, Class<?> collectionType) {
            if (array == null) {
                return null;
            }
            AbstractCollection collection = null;
            if (array.getClass().isArray()) {
                if (collectionType.isAssignableFrom(ArrayList.class)) {
                    collection = JettyXmlConfiguration.convertArrayToArrayList(array);
                } else if (collectionType.isAssignableFrom(HashSet.class)) {
                    collection = new HashSet<Object>(JettyXmlConfiguration.convertArrayToArrayList(array));
                }
            }
            if (collection == null) {
                throw new IllegalArgumentException("Can't convert \"" + array.getClass() + "\" to " + collectionType);
            }
            return collection;
        }

        private static ArrayList<Object> convertArrayToArrayList(Object array) {
            int length = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }

        private void put(Object obj, XmlParser.Node node) throws Exception {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("Object for put is not a Map: " + obj);
            }
            Map map = (Map)obj;
            String name = node.getAttribute("name");
            Object value = this.value(obj, node);
            map.put(name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + obj + ".put(" + name + "," + value + ")", new Object[0]);
            }
        }

        private Object get(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            String name = node.getAttribute("name");
            String id = node.getAttribute("id");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML get " + name, new Object[0]);
            }
            try {
                if ("class".equalsIgnoreCase(name)) {
                    obj = oClass;
                } else {
                    Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), new Class[0]);
                    obj = this.invokeMethod(method, obj, null, false);
                }
                if (id != null) {
                    this._configuration.getIdMap().put(id, obj);
                }
                this.configure(obj, node, 0);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field field = oClass.getField(name);
                    obj = this.getField(field, obj);
                    this.configure(obj, node, 0);
                }
                catch (NoSuchFieldException nsfe) {
                    throw nsme;
                }
            }
            return obj;
        }

        private Object call(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass;
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Name", "Class", "Arg");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name");
            String clazz = aoeNode.getString("Class");
            if (clazz != null) {
                oClass = Loader.loadClass(clazz);
                obj = null;
            } else if (obj != null) {
                oClass = obj.getClass();
            } else {
                throw new IllegalArgumentException(node.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML call " + name, new Object[0]);
            }
            try {
                Object nobj = this.call(oClass, name, obj, new Args(obj, oClass, aoeNode.getNodes("Arg")));
                if (id != null) {
                    this._configuration.getIdMap().put(id, nobj);
                }
                this.configure(nobj, node, aoeNode.getNext());
                return nobj;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No Method: " + node + " on " + oClass, e);
            }
        }

        private Object call(Class<?> oClass, String methodName, Object obj, Args args2) throws InvocationTargetException, NoSuchMethodException {
            Objects.requireNonNull(oClass, "Class cannot be null");
            Objects.requireNonNull(methodName, "Method name cannot be null");
            if (StringUtil.isBlank(methodName)) {
                throw new IllegalArgumentException("Method name cannot be blank");
            }
            Method[] methods = oClass.getMethods();
            Arrays.sort(methods, EXECUTABLE_COMPARATOR);
            for (Method method : methods) {
                Object[] arguments;
                if (!method.getName().equals(methodName) || (arguments = args2.applyTo(method)) == null || Modifier.isStatic(method.getModifiers()) != (obj == null) || obj == null && method.getDeclaringClass() != oClass) continue;
                try {
                    return this.invokeMethod(method, obj, arguments);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOG.ignore(e);
                }
            }
            throw new NoSuchMethodException(methodName);
        }

        private Object newObj(Object obj, XmlParser.Node node) throws Exception {
            Object nobj;
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Class", "Arg");
            String id = aoeNode.getString("Id");
            String clazz = aoeNode.getString("Class");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML new " + clazz, new Object[0]);
            }
            Class oClass = Loader.loadClass(clazz);
            try {
                nobj = this.construct(oClass, new Args(obj, oClass, aoeNode.getNodes("Arg")));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No suitable constructor: " + node + " on " + obj);
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, nobj);
            }
            this._configuration.initializeDefaults(nobj);
            this.configure(nobj, node, aoeNode.getNext());
            return nobj;
        }

        private Object construct(Class<?> klass, Args args2) throws InvocationTargetException, NoSuchMethodException {
            Objects.requireNonNull(klass, "Class cannot be null");
            Objects.requireNonNull(args2, "Named list cannot be null");
            Constructor<?>[] constructors = klass.getConstructors();
            Arrays.sort(constructors, EXECUTABLE_COMPARATOR);
            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] arguments = args2.applyTo(constructor);
                    if (arguments == null) continue;
                    return this.invokeConstructor(constructor, arguments);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                    LOG.ignore(e);
                }
            }
            throw new NoSuchMethodException("<init>");
        }

        private Object refObj(XmlParser.Node node) throws Exception {
            Object obj;
            String refid = node.getAttribute("refid");
            if (refid == null) {
                refid = node.getAttribute("id");
            }
            if ((obj = this._configuration.getIdMap().get(refid)) == null && node.size() > 0) {
                throw new IllegalStateException("No object for refid=" + refid);
            }
            this.configure(obj, node, 0);
            return obj;
        }

        private Object newArray(Object obj, XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Type", "Item");
            String id = aoeNode.getString("Id");
            String type = aoeNode.getString("Type");
            List<XmlParser.Node> items = aoeNode.getNodes("Item");
            Class aClass = Object.class;
            if (type != null && (aClass = TypeUtil.fromName(type)) == null) {
                switch (type) {
                    case "String": {
                        aClass = String.class;
                        break;
                    }
                    case "URL": {
                        aClass = URL.class;
                        break;
                    }
                    case "InetAddress": {
                        aClass = InetAddress.class;
                        break;
                    }
                    default: {
                        aClass = Loader.loadClass(type);
                    }
                }
            }
            Object al = null;
            for (XmlParser.Node item : items) {
                String nid = item.getAttribute("id");
                Object v = this.value(obj, item);
                al = LazyList.add(al, v == null && aClass.isPrimitive() ? Integer.valueOf(0) : v);
                if (nid == null) continue;
                this._configuration.getIdMap().put(nid, v);
            }
            Object array = LazyList.toArray(al, aClass);
            if (id != null) {
                this._configuration.getIdMap().put(id, array);
            }
            return array;
        }

        private Object newMap(Object obj, XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Entry");
            String id = aoeNode.getString("Id");
            List<XmlParser.Node> entries = aoeNode.getNodes("Entry");
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            if (id != null) {
                this._configuration.getIdMap().put(id, map);
            }
            for (XmlParser.Node entry : entries) {
                if (!entry.getTag().equals("Entry")) {
                    throw new IllegalStateException("Not an Entry");
                }
                XmlParser.Node key = null;
                XmlParser.Node value = null;
                for (Object object : entry) {
                    if (object instanceof String) continue;
                    XmlParser.Node item = (XmlParser.Node)object;
                    if (!item.getTag().equals("Item")) {
                        throw new IllegalStateException("Not an Item");
                    }
                    if (key == null) {
                        key = item;
                        continue;
                    }
                    value = item;
                }
                if (key == null || value == null) {
                    throw new IllegalStateException("Missing Item in Entry");
                }
                String kid = key.getAttribute("id");
                String vid = value.getAttribute("id");
                Object k = this.value(obj, key);
                Object v = this.value(obj, value);
                map.put(k, v);
                if (kid != null) {
                    this._configuration.getIdMap().put(kid, k);
                }
                if (vid == null) continue;
                this._configuration.getIdMap().put(vid, v);
            }
            return map;
        }

        private Object propertyObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", true);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            Map<String, String> properties = this._configuration.getProperties();
            String value = properties.get(name);
            String alternate = null;
            if (!deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    String v = properties.get(StringUtil.valueOf(d));
                    if (v != null) {
                        if (value == null) {
                            LOG.warn("Property '{}' is deprecated, use '{}' instead", d, name);
                        } else {
                            LOG.warn("Property '{}' is deprecated, value from '{}' used", d, name);
                        }
                    }
                    if (alternate != null) continue;
                    alternate = v;
                }
            }
            if (value == null) {
                value = alternate;
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object systemPropertyObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", true);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            String value = System.getProperty(name);
            String alternate = null;
            if (!deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    if (d == null) continue;
                    String v = System.getProperty(d.toString());
                    if (v != null) {
                        if (value == null) {
                            LOG.warn("SystemProperty '{}' is deprecated, use '{}' instead", d, name);
                        } else {
                            LOG.warn("SystemProperty '{}' is deprecated, value from '{}' used", d, name);
                        }
                    }
                    if (alternate != null) continue;
                    alternate = v;
                }
            }
            if (value == null) {
                value = alternate;
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object envObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", true);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            String value = System.getenv(name);
            if (value == null && !deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    value = System.getenv(StringUtil.valueOf(d));
                    if (value == null) continue;
                    LOG.warn("Property '{}' is deprecated, use '{}' instead", d, name);
                    break;
                }
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private String defaultValue(Object obj, XmlParser.Node node) throws Exception {
            StringBuilder ret = new StringBuilder();
            this.appendDefaultPropertyValues(ret, node);
            return ret.toString();
        }

        private void appendDefaultPropertyValues(StringBuilder defValues, XmlParser.Node node) throws Exception {
            for (Object child : node) {
                AttrOrElementNode aoeNode;
                String dftValue;
                if (!(child instanceof XmlParser.Node)) continue;
                XmlParser.Node childNode = (XmlParser.Node)child;
                String tag = childNode.getTag();
                if (("Property".equals(tag) || "SystemProperty".equals(tag)) && (dftValue = (aoeNode = new AttrOrElementNode(childNode, "Id", "Name", "Deprecated", "Default")).getString("Default")) != null) {
                    defValues.append(dftValue);
                }
                this.appendDefaultPropertyValues(defValues, childNode);
            }
        }

        private Object value(Object obj, XmlParser.Node node) throws Exception {
            Object value;
            String type = node.getAttribute("type");
            String ref = node.getAttribute("ref");
            if (ref != null) {
                value = this._configuration.getIdMap().get(ref);
            } else {
                int i;
                StringBuilder buf;
                int first;
                if (node.size() == 0) {
                    if ("String".equals(type)) {
                        return "";
                    }
                    return null;
                }
                int last = node.size() - 1;
                if ("String".equals(type)) {
                    if (first == last) {
                        value = this.itemValue(obj, node.get(first));
                    } else {
                        buf = new StringBuilder();
                        for (i = first; i <= last; ++i) {
                            Object item = node.get(i);
                            buf.append(this.itemValue(obj, item));
                        }
                        value = buf.toString();
                    }
                } else {
                    Object item;
                    for (first = 0; first <= last && (item = node.get(first)) instanceof String && ((String)item).trim().length() <= 0; ++first) {
                    }
                    while (first < last && (item = node.get(last)) instanceof String && ((String)item).trim().length() <= 0) {
                        --last;
                    }
                    if (first > last) {
                        return null;
                    }
                    if (first == last) {
                        value = this.itemValue(obj, node.get(first));
                        if (value instanceof String) {
                            value = ((String)value).trim();
                        }
                    } else {
                        buf = new StringBuilder();
                        for (i = first; i <= last; ++i) {
                            buf.append(this.itemValue(obj, node.get(i)));
                        }
                        value = buf.toString().trim();
                    }
                }
            }
            if (value == null) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            if (type == null) {
                return value;
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, String.class)) {
                return value.toString();
            }
            Class<?> pClass = TypeUtil.fromName(type);
            if (pClass != null) {
                return TypeUtil.valueOf(pClass, value.toString());
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, URL.class)) {
                if (value instanceof URL) {
                    return value;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new InvocationTargetException(e);
                }
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, InetAddress.class)) {
                if (value instanceof InetAddress) {
                    return value;
                }
                try {
                    return InetAddress.getByName(value.toString());
                }
                catch (UnknownHostException e) {
                    throw new InvocationTargetException(e);
                }
            }
            for (Class collectionClass : __supportedCollections) {
                if (!JettyXmlConfiguration.isTypeMatchingClass(type, collectionClass)) continue;
                return JettyXmlConfiguration.convertArrayToCollection(value, collectionClass);
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        private static boolean isTypeMatchingClass(String type, Class<?> classToMatch) {
            return classToMatch.getSimpleName().equalsIgnoreCase(type) || classToMatch.getName().equals(type);
        }

        private Object itemValue(Object obj, Object item) throws Exception {
            if (item instanceof String) {
                return item;
            }
            XmlParser.Node node = (XmlParser.Node)item;
            String tag = node.getTag();
            if ("Call".equals(tag)) {
                return this.call(obj, node);
            }
            if ("Get".equals(tag)) {
                return this.get(obj, node);
            }
            if ("New".equals(tag)) {
                return this.newObj(obj, node);
            }
            if ("Ref".equals(tag)) {
                return this.refObj(node);
            }
            if ("Array".equals(tag)) {
                return this.newArray(obj, node);
            }
            if ("Map".equals(tag)) {
                return this.newMap(obj, node);
            }
            if ("Property".equals(tag)) {
                return this.propertyObj(node);
            }
            if ("SystemProperty".equals(tag)) {
                return this.systemPropertyObj(node);
            }
            if ("Env".equals(tag)) {
                return this.envObj(node);
            }
            LOG.warn("Unknown value tag: " + node + " in " + this._configuration, new Throwable());
            return null;
        }

        private class Args {
            private final Class<?> _class;
            private final List<Object> _arguments;
            private final List<String> _names;

            private Args(Object obj, Class<?> oClass, List<XmlParser.Node> args2) throws Exception {
                this._class = oClass;
                this._arguments = new ArrayList<Object>();
                this._names = new ArrayList<String>();
                for (XmlParser.Node child : args2) {
                    this._arguments.add(JettyXmlConfiguration.this.value(obj, child));
                    this._names.add(child.getAttribute("name"));
                }
            }

            private Args(List<Object> arguments, List<String> names) {
                this._class = null;
                this._arguments = arguments;
                this._names = names;
            }

            Object[] applyTo(Executable executable) {
                int count;
                Object[] args2 = this.matchArgsToParameters(executable);
                if (args2 == null && this._class != null && (count = executable.getParameterCount()) > 0 && executable.getParameters()[count - 1].isVarArgs()) {
                    args2 = this.asEmptyVarArgs(executable.getParameterTypes()[count - 1]).matchArgsToParameters(executable);
                }
                return args2;
            }

            Args asEmptyVarArgs(Class<?> varArgType) {
                ArrayList<Object> arguments = new ArrayList<Object>(this._arguments);
                arguments.add(Array.newInstance(varArgType.getComponentType(), 0));
                ArrayList<String> names = new ArrayList<String>(this._names);
                names.add(null);
                return new Args(arguments, names);
            }

            Object[] matchArgsToParameters(Executable executable) {
                Object[] args2;
                int count = executable.getParameterCount();
                if (count != this._arguments.size()) {
                    return null;
                }
                if (count == 0) {
                    return new Object[0];
                }
                if (this._names.stream().noneMatch(Objects::nonNull)) {
                    args2 = this._arguments.toArray(new Object[0]);
                } else {
                    Annotation[][] parameterAnnotations = executable.getParameterAnnotations();
                    if (parameterAnnotations == null || parameterAnnotations.length == 0) {
                        return null;
                    }
                    HashMap position = new HashMap();
                    int p = 0;
                    for (Annotation[] paramAnnotation : parameterAnnotations) {
                        Integer pos = p++;
                        Arrays.stream(paramAnnotation).filter(Name.class::isInstance).map(Name.class::cast).findFirst().ifPresent(n -> position.put(n.value(), pos));
                    }
                    ArrayList<Object> arguments = new ArrayList<Object>(this._arguments);
                    ArrayList<String> names = new ArrayList<String>(this._names);
                    for (p = 0; p < count; ++p) {
                        String name = (String)names.get(p);
                        if (name == null) continue;
                        Integer pos = (Integer)position.get(name);
                        if (pos == null) {
                            return null;
                        }
                        if (pos == p) continue;
                        arguments.add(pos, arguments.remove(p));
                        names.add(pos, (String)names.remove(p));
                        p = Math.min(p, pos);
                    }
                    args2 = arguments.toArray(new Object[0]);
                }
                return args2;
            }
        }

        private class AttrOrElementNode {
            final Object _obj;
            final XmlParser.Node _node;
            final Set<String> _elements = new HashSet<String>();
            final int _next;

            AttrOrElementNode(XmlParser.Node node, String ... elements) {
                this(null, node, elements);
            }

            AttrOrElementNode(Object obj, XmlParser.Node node, String ... elements) {
                this._obj = obj;
                this._node = node;
                Collections.addAll(this._elements, elements);
                int next = 0;
                for (Object o : this._node) {
                    XmlParser.Node n;
                    if (o instanceof String) {
                        if (((String)o).trim().length() != 0) break;
                        ++next;
                        continue;
                    }
                    if (!(o instanceof XmlParser.Node) || !this._elements.contains((n = (XmlParser.Node)o).getTag())) break;
                    ++next;
                }
                this._next = next;
            }

            public int getNext() {
                return this._next;
            }

            public String getString(String elementName) throws Exception {
                return StringUtil.valueOf(this.get(elementName, false));
            }

            public String getString(String elementName, boolean mandatory) throws Exception {
                return StringUtil.valueOf(this.get(elementName, mandatory));
            }

            public Object get(String elementName, boolean mandatory) throws Exception {
                String attrName = StringUtil.asciiToLowerCase(elementName);
                String attr = this._node.getAttribute(attrName);
                Object value = attr;
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node n;
                    Object o = this._node.get(i);
                    if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
                    if (attr != null) {
                        throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
                    }
                    value = JettyXmlConfiguration.this.value(this._obj, n);
                    break;
                }
                if (mandatory && value == null) {
                    throw new IllegalStateException("Must have attr '" + attrName + "' or element '" + elementName + "'");
                }
                return value;
            }

            public List<Object> getList(String elementName) throws Exception {
                return this.getList(elementName, false);
            }

            public List<Object> getList(String elementName, boolean manditory) throws Exception {
                String attrName = StringUtil.asciiToLowerCase(elementName);
                ArrayList<Object> values2 = new ArrayList<Object>();
                String attr = this._node.getAttribute(attrName);
                if (attr != null) {
                    values2.addAll(StringUtil.csvSplit(null, attr, 0, attr.length()));
                }
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node n;
                    Object o = this._node.get(i);
                    if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
                    if (attr != null) {
                        throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
                    }
                    values2.add(JettyXmlConfiguration.this.value(this._obj, n));
                }
                if (manditory && values2.isEmpty()) {
                    throw new IllegalStateException("Must have attr '" + attrName + "' or element '" + elementName + "'");
                }
                return values2;
            }

            public List<XmlParser.Node> getNodes(String elementName) {
                return XmlConfiguration.getNodes(this._node, elementName);
            }
        }
    }
}

