/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.BootstrapRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieBootstrapHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.keygen.KeyGeneratorInterface;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.bootstrap.BaseBootstrapMetadataHandler;
import org.apache.hudi.table.action.bootstrap.BootstrapRecordConsumer;
import org.apache.hudi.util.ExecutorFactory;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

class ParquetBootstrapMetadataHandler
extends BaseBootstrapMetadataHandler {
    public ParquetBootstrapMetadataHandler(HoodieWriteConfig config, HoodieTable table, HoodieFileStatus srcFileStatus) {
        super(config, table, srcFileStatus);
    }

    @Override
    Schema getAvroSchema(Path sourceFilePath) throws IOException {
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)this.table.getHadoopConf(), (Path)sourceFilePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType parquetSchema = readFooter.getFileMetaData().getSchema();
        return new AvroSchemaConverter().convert(parquetSchema);
    }

    @Override
    protected void executeBootstrap(HoodieBootstrapHandle<?, ?, ?, ?> bootstrapHandle, Path sourceFilePath, KeyGeneratorInterface keyGenerator, String partitionPath, Schema schema) throws Exception {
        HoodieRecord.HoodieRecordType recordType = this.table.getConfig().getRecordMerger().getRecordType();
        HoodieFileReader reader = HoodieFileReaderFactory.getReaderFactory(recordType).getFileReader(this.table.getHadoopConf(), sourceFilePath);
        HoodieExecutor<Void> executor = null;
        try {
            Function<HoodieRecord, HoodieRecord> transformer = record -> {
                String recordKey = record.getRecordKey(schema, Option.of(keyGenerator));
                return this.createNewMetadataBootstrapRecord(recordKey, partitionPath, recordType).copy();
            };
            ClosableIterator recordIterator = reader.getRecordIterator(schema);
            executor = ExecutorFactory.create(this.config, recordIterator, new BootstrapRecordConsumer(bootstrapHandle), transformer, this.table.getPreExecuteRunnable());
            executor.execute();
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
                executor.awaitTermination();
            } else {
                reader.close();
                bootstrapHandle.close();
            }
        }
    }

    private HoodieRecord createNewMetadataBootstrapRecord(String recordKey, String partitionPath, HoodieRecord.HoodieRecordType recordType) {
        HoodieKey hoodieKey = new HoodieKey(recordKey, partitionPath);
        switch (recordType) {
            case AVRO: {
                GenericData.Record avroRecord = new GenericData.Record(HoodieBootstrapHandle.METADATA_BOOTSTRAP_RECORD_SCHEMA);
                avroRecord.put(HoodieRecord.RECORD_KEY_METADATA_FIELD, (Object)recordKey);
                BootstrapRecordPayload payload = new BootstrapRecordPayload((GenericRecord)avroRecord);
                return new HoodieAvroRecord<BootstrapRecordPayload>(hoodieKey, payload);
            }
            case SPARK: {
                StructType schema = HoodieInternalRowUtils$.MODULE$.getCachedSchema(HoodieBootstrapHandle.METADATA_BOOTSTRAP_RECORD_SCHEMA);
                UnsafeProjection unsafeProjection = HoodieInternalRowUtils$.MODULE$.getCachedUnsafeProjection(schema, schema);
                GenericInternalRow row = new GenericInternalRow(HoodieBootstrapHandle.METADATA_BOOTSTRAP_RECORD_SCHEMA.getFields().size());
                row.update(HoodieRecord.RECORD_KEY_META_FIELD_ORD, (Object)UTF8String.fromString((String)recordKey));
                UnsafeRow unsafeRow = unsafeProjection.apply((InternalRow)row);
                return new HoodieSparkRecord(hoodieKey, unsafeRow, false);
            }
        }
        throw new UnsupportedOperationException(String.format("Record type %s is not supported yet!", new Object[]{recordType}));
    }
}

