/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.time.Duration;
import java.time.Instant;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.ParallelismHelper;

public abstract class BaseWriteHelper<T, I, K, O, R>
extends ParallelismHelper<I> {
    protected BaseWriteHelper(SerializableFunctionUnchecked<I, Integer> partitionNumberExtractor) {
        super(partitionNumberExtractor);
    }

    public HoodieWriteMetadata<O> write(String instantTime, I inputRecords, HoodieEngineContext context, HoodieTable<T, I, K, O> table, boolean shouldCombine, int configuredShuffleParallelism, BaseCommitActionExecutor<T, I, K, O, R> executor, WriteOperationType operationType) {
        try {
            I dedupedRecords = this.combineOnCondition(shouldCombine, inputRecords, configuredShuffleParallelism, table);
            Instant lookupBegin = Instant.now();
            I taggedRecords = dedupedRecords;
            if (table.getIndex().requiresTagging(operationType)) {
                context.setJobStatus(this.getClass().getSimpleName(), "Tagging: " + table.getConfig().getTableName());
                taggedRecords = this.tag(dedupedRecords, context, table);
            }
            Duration indexLookupDuration = Duration.between(lookupBegin, Instant.now());
            HoodieWriteMetadata<O> result = executor.execute(taggedRecords);
            result.setIndexLookupDuration(indexLookupDuration);
            return result;
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw (HoodieUpsertException)e;
            }
            throw new HoodieUpsertException("Failed to upsert for commit time " + instantTime, e);
        }
    }

    protected abstract I tag(I var1, HoodieEngineContext var2, HoodieTable<T, I, K, O> var3);

    public I combineOnCondition(boolean condition, I records, int configuredParallelism, HoodieTable<T, I, K, O> table) {
        int targetParallelism = this.deduceShuffleParallelism(records, configuredParallelism);
        return condition ? this.deduplicateRecords(records, table, targetParallelism) : records;
    }

    public I deduplicateRecords(I records, HoodieTable<T, I, K, O> table, int parallelism) {
        HoodieRecordMerger recordMerger = HoodieRecordUtils.mergerToPreCombineMode(table.getConfig().getRecordMerger());
        return this.deduplicateRecords(records, table.getIndex(), parallelism, table.getConfig().getSchema(), table.getConfig().getProps(), recordMerger);
    }

    public abstract I deduplicateRecords(I var1, HoodieIndex<?, ?> var2, int var3, String var4, TypedProperties var5, HoodieRecordMerger var6);
}

