/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.action.index.AbstractIndexingCatchupTask;

public class RecordBasedIndexingCatchupTask
extends AbstractIndexingCatchupTask {
    public RecordBasedIndexingCatchupTask(HoodieTableMetadataWriter metadataWriter, List<HoodieInstant> instantsToIndex, Set<String> metadataCompletedInstants, HoodieTableMetaClient metaClient, HoodieTableMetaClient metadataMetaClient, String currentCaughtupInstant, TransactionManager transactionManager, HoodieEngineContext engineContext) {
        super(metadataWriter, instantsToIndex, metadataCompletedInstants, metaClient, metadataMetaClient, transactionManager, currentCaughtupInstant, engineContext);
    }

    @Override
    public void updateIndexForWriteAction(HoodieInstant instant) throws IOException {
        HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.metaClient.getActiveTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
        HoodieData<HoodieRecord> records = this.readRecordKeysFromFileSlices(instant);
        this.metadataWriter.update(commitMetadata, records, instant.getTimestamp());
    }

    private HoodieData<HoodieRecord> readRecordKeysFromFileSlices(HoodieInstant instant) throws IOException {
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieTableMetadata metadata = HoodieTableMetadata.create(this.engineContext, metadataConfig, this.metaClient.getBasePathV2().toString(), false);
        HoodieMetadataFileSystemView fsView = new HoodieMetadataFileSystemView(this.metaClient, this.metaClient.getActiveTimeline().filter(i -> i.equals(instant)), metadata);
        List<String> partitions = metadata.getAllPartitionPaths();
        fsView.loadAllPartitions();
        ArrayList<Pair<String, FileSlice>> partitionFileSlicePairs = new ArrayList<Pair<String, FileSlice>>();
        for (String partition : partitions) {
            fsView.getLatestFileSlices(partition).forEach(fs -> partitionFileSlicePairs.add(Pair.of(partition, fs)));
        }
        return HoodieTableMetadataUtil.readRecordKeysFromFileSlices(this.engineContext, partitionFileSlicePairs, false, metadataConfig.getRecordIndexMaxParallelism(), this.getClass().getSimpleName(), this.metaClient, EngineType.SPARK);
    }
}

