/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.unsafe;

import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.UTF8String;

public class UTF8StringBuilder {
    private static final int ARRAY_MAX = ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH;
    private byte[] buffer;
    private int cursor = Platform.BYTE_ARRAY_OFFSET;

    public UTF8StringBuilder() {
        this(16);
    }

    public UTF8StringBuilder(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        if (initialSize > ARRAY_MAX) {
            throw new IllegalArgumentException("Size " + initialSize + " exceeded maximum size of " + ARRAY_MAX);
        }
        this.buffer = new byte[initialSize];
    }

    private void grow(int neededSize) {
        if (neededSize > ARRAY_MAX - this.totalSize()) {
            throw new UnsupportedOperationException("Cannot grow internal buffer by size " + neededSize + " because the size after growing exceeds size limitation " + ARRAY_MAX);
        }
        int length = this.totalSize() + neededSize;
        if (this.buffer.length < length) {
            int newLength = length < ARRAY_MAX / 2 ? length * 2 : ARRAY_MAX;
            byte[] tmp = new byte[newLength];
            Platform.copyMemory((Object)this.buffer, (long)Platform.BYTE_ARRAY_OFFSET, (Object)tmp, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.totalSize());
            this.buffer = tmp;
        }
    }

    private int totalSize() {
        return this.cursor - Platform.BYTE_ARRAY_OFFSET;
    }

    public void append(UTF8String value) {
        this.grow(value.numBytes());
        value.writeToMemory((Object)this.buffer, (long)this.cursor);
        this.cursor += value.numBytes();
    }

    public void append(String value) {
        this.append(UTF8String.fromString((String)value));
    }

    public void appendBytes(Object base, long offset, int length) {
        this.grow(length);
        Platform.copyMemory((Object)base, (long)offset, (Object)this.buffer, (long)this.cursor, (long)length);
        this.cursor += length;
    }

    public UTF8String build() {
        return UTF8String.fromBytes((byte[])this.buffer, (int)0, (int)this.totalSize());
    }
}

