/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.utilities.config.HoodieIncrSourceConfig;

@ConfigClassProperty(name="Cloud Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configs that are common during ingestion across different cloud stores")
@Immutable
public class CloudSourceConfig
extends HoodieConfig {
    public static final ConfigProperty<Integer> BATCH_SIZE_CONF = ConfigProperty.key("hoodie.streamer.source.cloud.meta.batch.size").defaultValue(10).withAlternatives("hoodie.deltastreamer.source.cloud.meta.batch.size").markAdvanced().withDocumentation("Number of metadata messages to pull in one API call to the cloud events queue. Multiple API calls with this batch size are sent to cloud events queue, until we consume hoodie.streamer.source.cloud.meta.max.num.messages.per.syncfrom the queue or hoodie.streamer.source.cloud.meta.max.fetch.time.per.sync.ms amount of time has passed or queue is empty. ");
    public static final ConfigProperty<Integer> MAX_NUM_MESSAGES_PER_SYNC = ConfigProperty.key("hoodie.streamer.source.cloud.meta.max.num.messages.per.sync").defaultValue(1000).markAdvanced().sinceVersion("0.14.1").withDocumentation("Maximum number of messages to consume per sync round. Multiple rounds of " + BATCH_SIZE_CONF.key() + " could be invoked to reach max messages as configured by this config");
    public static final ConfigProperty<Boolean> ACK_MESSAGES = ConfigProperty.key("hoodie.streamer.source.cloud.meta.ack").defaultValue(true).withAlternatives("hoodie.deltastreamer.source.cloud.meta.ack").markAdvanced().withDocumentation("Whether to acknowledge Metadata messages during Cloud Ingestion or not. This is useful during dev and testing.\n In Prod this should always be true. In case of Cloud Pubsub, not acknowledging means Pubsub will keep redelivering the same messages.");
    public static final ConfigProperty<Boolean> ENABLE_EXISTS_CHECK = ConfigProperty.key("hoodie.streamer.source.cloud.data.check.file.exists").defaultValue(false).withAlternatives("hoodie.deltastreamer.source.cloud.data.check.file.exists").markAdvanced().withDocumentation("If true, checks whether file exists before attempting to pull it");
    public static final ConfigProperty<String> SELECT_RELATIVE_PATH_PREFIX = ConfigProperty.key("hoodie.streamer.source.cloud.data.select.relpath.prefix").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.select.relpath.prefix").markAdvanced().withDocumentation("Only selects objects in the bucket whose relative path matches this prefix");
    public static final ConfigProperty<String> IGNORE_RELATIVE_PATH_PREFIX = ConfigProperty.key("hoodie.streamer.source.cloud.data.ignore.relpath.prefix").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.ignore.relpath.prefix").markAdvanced().withDocumentation("Ignore objects in the bucket whose relative path matches this prefix");
    public static final ConfigProperty<String> IGNORE_RELATIVE_PATH_SUBSTR = ConfigProperty.key("hoodie.streamer.source.cloud.data.ignore.relpath.substring").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.ignore.relpath.substring").markAdvanced().withDocumentation("Ignore objects in the bucket whose relative path contains this substring");
    public static final ConfigProperty<String> SPARK_DATASOURCE_OPTIONS = ConfigProperty.key("hoodie.streamer.source.cloud.data.datasource.options").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.datasource.options").markAdvanced().withDocumentation("A JSON string passed to the Spark DataFrameReader while loading the dataset. Example: hoodie.streamer.gcp.spark.datasource.options={\"header\":\"true\",\"encoding\":\"UTF-8\"}\n");
    public static final ConfigProperty<String> CLOUD_DATAFILE_EXTENSION = ConfigProperty.key("hoodie.streamer.source.cloud.data.select.file.extension").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.select.file.extension").markAdvanced().withDocumentation("Only match files with this extension. By default, this is the same as hoodie.streamer.source.hoodieincr.file.format");
    public static final ConfigProperty<String> DATAFILE_FORMAT = ConfigProperty.key("hoodie.streamer.source.cloud.data.datafile.format").defaultValue(HoodieIncrSourceConfig.SOURCE_FILE_FORMAT.defaultValue()).withAlternatives("hoodie.deltastreamer.source.cloud.data.datafile.format").markAdvanced().withDocumentation("Format of the data file. By default, this will be the same as hoodie.streamer.source.hoodieincr.file.format");
    public static final ConfigProperty<String> PATH_BASED_PARTITION_FIELDS = ConfigProperty.key("hoodie.streamer.source.cloud.data.partition.fields.from.path").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.partition.fields.from.path").markAdvanced().sinceVersion("0.14.0").withDocumentation("A comma delimited list of path-based partition fields in the source file structure.");
    public static final ConfigProperty<Boolean> SPARK_DATASOURCE_READER_COMMA_SEPARATED_PATH_FORMAT = ConfigProperty.key("hoodie.streamer.source.cloud.data.reader.comma.separated.path.format").defaultValue(false).markAdvanced().sinceVersion("0.14.1").withDocumentation("Boolean value for specifying path format in load args of spark.read.format(\"..\").load(\"a.xml,b.xml,c.xml\"),\n   * set true if path format needs to be comma separated string value, if false it's passed as array of strings like\n   * spark.read.format(\"..\").load(new String[]{a.xml,b.xml,c.xml})");
    public static final ConfigProperty<String> SOURCE_MAX_BYTES_PER_PARTITION = ConfigProperty.key("hoodie.streamer.source.cloud.data.partition.max.size").noDefaultValue().markAdvanced().sinceVersion("0.14.1").withDocumentation("specify this value in bytes, to coalesce partitions of source dataset not greater than specified limit");
    public static final ConfigProperty<Integer> MAX_FETCH_TIME_PER_SYNC_SECS = ConfigProperty.key("hoodie.streamer.source.cloud.meta.max.fetch.time.per.sync.secs").defaultValue(60).markAdvanced().sinceVersion("0.14.1").withDocumentation("Max time in secs to consume " + MAX_NUM_MESSAGES_PER_SYNC.key() + " messages from cloud queue. Cloud event queues like SQS, PubSub can return empty responses even when messages are available the queue, this config ensures we don't wait forever to consume MAX_MESSAGES_CONF messages, but time out and move on further.");
}

