/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.config.HoodieCompactionConfig;

@ConfigClassProperty(name="Hudi Streamer Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, areCommonConfigs=true, description="")
@Immutable
public class HoodieStreamerConfig
extends HoodieConfig {
    public static final String INGESTION_PREFIX = "hoodie.streamer.ingestion.";
    @Deprecated
    public static final String OLD_INGESTION_PREFIX = "hoodie.deltastreamer.ingestion.";
    public static final ConfigProperty<String> CHECKPOINT_PROVIDER_PATH = ConfigProperty.key("hoodie.streamer.checkpoint.provider.path").noDefaultValue().withAlternatives("hoodie.deltastreamer.checkpoint.provider.path").markAdvanced().withDocumentation("The path for providing the checkpoints.");
    public static final ConfigProperty<Boolean> CHECKPOINT_FORCE_SKIP = ConfigProperty.key("hoodie.streamer.checkpoint.force.skip").defaultValue(false).withAlternatives("hoodie.deltastreamer.checkpoint.force.skip").markAdvanced().withDocumentation("Config to force to skip saving checkpoint in the commit metadata.It is typically used in one-time backfill scenarios, where checkpoints are not to be persisted.");
    public static final ConfigProperty<String> KAFKA_TOPIC = ConfigProperty.key("hoodie.streamer.source.kafka.topic").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.kafka.topic").withDocumentation("Kafka topic name. The config is specific to HoodieMultiTableStreamer");
    public static final ConfigProperty<String> KAFKA_APPEND_OFFSETS = ConfigProperty.key("hoodie.streamer.source.kafka.append.offsets").defaultValue("false").withAlternatives("hoodie.deltastreamer.source.kafka.append.offsets").markAdvanced().withDocumentation("When enabled, appends kafka offset info like source offset(_hoodie_kafka_source_offset), partition (_hoodie_kafka_source_partition) and timestamp (_hoodie_kafka_source_timestamp) to the records. By default its disabled and no kafka offsets are added");
    public static final ConfigProperty<Boolean> SANITIZE_SCHEMA_FIELD_NAMES = ConfigProperty.key("hoodie.streamer.source.sanitize.invalid.schema.field.names").defaultValue(false).withAlternatives("hoodie.deltastreamer.source.sanitize.invalid.schema.field.names").markAdvanced().withDocumentation("Sanitizes names of invalid schema fields both in the data read from source and also in the schema Replaces invalid characters with hoodie.streamer.source.sanitize.invalid.char.mask. Invalid characters are by goes by avro naming convention (https://avro.apache.org/docs/current/spec.html#names).");
    public static final ConfigProperty<String> SCHEMA_FIELD_NAME_INVALID_CHAR_MASK = ConfigProperty.key("hoodie.streamer.source.sanitize.invalid.char.mask").defaultValue("__").withAlternatives("hoodie.deltastreamer.source.sanitize.invalid.char.mask").markAdvanced().withDocumentation("Defines the character sequence that replaces invalid characters in schema field names if hoodie.streamer.source.sanitize.invalid.schema.field.names is enabled.");
    public static final ConfigProperty<String> TABLES_TO_BE_INGESTED = ConfigProperty.key("hoodie.streamer.ingestion.tablesToBeIngested").noDefaultValue().withAlternatives("hoodie.deltastreamer.ingestion.tablesToBeIngested").markAdvanced().withDocumentation("Comma separated names of tables to be ingested in the format <database>.<table>, for example db1.table1,db1.table2");
    public static final ConfigProperty<String> TARGET_BASE_PATH = ConfigProperty.key("hoodie.streamer.ingestion.targetBasePath").defaultValue("").withAlternatives("hoodie.deltastreamer.ingestion.targetBasePath").markAdvanced().withDocumentation("The path to which a particular table is ingested. The config is specific to HoodieMultiTableStreamer and overrides path determined using option `--base-path-prefix` for a table. This config is ignored for a single table streamer");
    public static final ConfigProperty<String> TRANSFORMER_CLASS = ConfigProperty.key("hoodie.streamer.transformer.class").noDefaultValue().withAlternatives("hoodie.deltastreamer.transformer.class").markAdvanced().sinceVersion("0.14.0").withDocumentation("Names of transformer classes to apply. The config is specific to HoodieMultiTableStreamer.");
    public static final ConfigProperty<Boolean> SAMPLE_WRITES_ENABLED = ConfigProperty.key("hoodie.streamer.sample.writes.enabled").defaultValue(false).withAlternatives("hoodie.deltastreamer.sample.writes.enabled").markAdvanced().sinceVersion("0.14.0").withDocumentation("Set this to true to sample from the first batch of records and write to the auxiliary path, before writing to the table.The sampled records are used to calculate the average record size. The relevant write client will have `" + HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.key() + "` being overwritten by the calculated result.");
    public static final ConfigProperty<Integer> SAMPLE_WRITES_SIZE = ConfigProperty.key("hoodie.streamer.sample.writes.size").defaultValue(5000).withAlternatives("hoodie.deltastreamer.sample.writes.size").markAdvanced().sinceVersion("0.14.0").withDocumentation("Number of records to sample from the first write. To improve the estimation's accuracy, for smaller or more compressable record size, set the sample size bigger. For bigger or less compressable record size, set smaller.");
}

