/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.utilities.config.FilebasedSchemaProviderConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaProviderException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.helpers.SanitizationUtils;
import org.apache.spark.api.java.JavaSparkContext;

public class FilebasedSchemaProvider
extends SchemaProvider {
    private final FileSystem fs;
    protected Schema sourceSchema;
    protected Schema targetSchema;

    public FilebasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(FilebasedSchemaProviderConfig.SOURCE_SCHEMA_FILE));
        String sourceFile = ConfigUtils.getStringWithAltKeys(props, FilebasedSchemaProviderConfig.SOURCE_SCHEMA_FILE);
        boolean shouldSanitize = SanitizationUtils.shouldSanitize(props);
        String invalidCharMask = SanitizationUtils.getInvalidCharMask(props);
        this.fs = FSUtils.getFs(sourceFile, jssc.hadoopConfiguration(), true);
        this.sourceSchema = FilebasedSchemaProvider.readAvroSchemaFromFile(sourceFile, this.fs, shouldSanitize, invalidCharMask);
        if (ConfigUtils.containsConfigProperty(props, FilebasedSchemaProviderConfig.TARGET_SCHEMA_FILE)) {
            this.targetSchema = FilebasedSchemaProvider.readAvroSchemaFromFile(ConfigUtils.getStringWithAltKeys(props, FilebasedSchemaProviderConfig.TARGET_SCHEMA_FILE), this.fs, shouldSanitize, invalidCharMask);
        }
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }

    private static Schema readAvroSchemaFromFile(String schemaPath, FileSystem fs, boolean sanitizeSchema, String invalidCharMask) {
        String schemaStr;
        try (FSDataInputStream in = fs.open(new Path(schemaPath));){
            schemaStr = FileIOUtils.readAsUTFString((InputStream)in);
        }
        catch (IOException ioe) {
            throw new HoodieSchemaProviderException(String.format("Error reading schema from file %s", schemaPath), ioe);
        }
        return SanitizationUtils.parseAvroSchema(schemaStr, sanitizeSchema, invalidCharMask);
    }
}

