/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.JdbcbasedSchemaProviderConfig;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class JdbcbasedSchemaProvider
extends SchemaProvider {
    private Schema sourceSchema;
    private Map<String, String> options = new HashMap<String, String>();

    public JdbcbasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        this.options.put("url", ConfigUtils.getStringWithAltKeys(props, JdbcbasedSchemaProviderConfig.SOURCE_SCHEMA_JDBC_CONNECTION_URL));
        this.options.put("driver", ConfigUtils.getStringWithAltKeys(props, JdbcbasedSchemaProviderConfig.SOURCE_SCHEMA_JDBC_DRIVER_TYPE));
        this.options.put("user", ConfigUtils.getStringWithAltKeys(props, JdbcbasedSchemaProviderConfig.SOURCE_SCHEMA_JDBC_USERNAME));
        this.options.put("password", ConfigUtils.getStringWithAltKeys(props, JdbcbasedSchemaProviderConfig.SOURCE_SCHEMA_JDBC_PASSWORD));
        this.options.put("dbtable", ConfigUtils.getStringWithAltKeys(props, JdbcbasedSchemaProviderConfig.SOURCE_SCHEMA_JDBC_DBTABLE));
        this.options.put("queryTimeout", ConfigUtils.getStringWithAltKeys(props, JdbcbasedSchemaProviderConfig.SOURCE_SCHEMA_JDBC_TIMEOUT, "0"));
        this.options.put("nullable", ConfigUtils.getStringWithAltKeys(props, JdbcbasedSchemaProviderConfig.SOURCE_SCHEMA_JDBC_NULLABLE, "true"));
    }

    @Override
    public Schema getSourceSchema() {
        if (this.sourceSchema != null) {
            return this.sourceSchema;
        }
        return UtilHelpers.getJDBCSchema(this.options);
    }
}

