/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.hudi.utilities.schema.SchemaPostProcessor;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetPostProcessor
extends SchemaPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaOffsetPostProcessor.class);
    public static final String KAFKA_SOURCE_OFFSET_COLUMN = "_hoodie_kafka_source_offset";
    public static final String KAFKA_SOURCE_PARTITION_COLUMN = "_hoodie_kafka_source_partition";
    public static final String KAFKA_SOURCE_TIMESTAMP_COLUMN = "_hoodie_kafka_source_timestamp";
    public static final String KAFKA_SOURCE_KEY_COLUMN = "_hoodie_kafka_source_key";

    public KafkaOffsetPostProcessor(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
    }

    @Override
    public Schema processSchema(Schema schema) {
        try {
            List fieldList = schema.getFields();
            List newFieldList = fieldList.stream().map(f -> new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal())).collect(Collectors.toList());
            newFieldList.add(new Schema.Field(KAFKA_SOURCE_OFFSET_COLUMN, Schema.create((Schema.Type)Schema.Type.LONG), "offset column", (Object)0));
            newFieldList.add(new Schema.Field(KAFKA_SOURCE_PARTITION_COLUMN, Schema.create((Schema.Type)Schema.Type.INT), "partition column", (Object)0));
            newFieldList.add(new Schema.Field(KAFKA_SOURCE_TIMESTAMP_COLUMN, Schema.create((Schema.Type)Schema.Type.LONG), "timestamp column", (Object)0));
            newFieldList.add(new Schema.Field(KAFKA_SOURCE_KEY_COLUMN, AvroSchemaUtils.createNullableSchema(Schema.Type.STRING), "kafka key column", (Object)JsonProperties.NULL_VALUE));
            Schema newSchema = Schema.createRecord((String)(schema.getName() + "_processed"), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false, newFieldList);
            return newSchema;
        }
        catch (Exception e) {
            throw new HoodieSchemaException("Kafka offset post processor failed with schema: " + schema, e);
        }
    }

    public static class Config {
        @Deprecated
        public static final ConfigProperty<String> KAFKA_APPEND_OFFSETS = HoodieStreamerConfig.KAFKA_APPEND_OFFSETS;

        public static boolean shouldAddOffsets(TypedProperties props) {
            return ConfigUtils.getBooleanWithAltKeys(props, HoodieStreamerConfig.KAFKA_APPEND_OFFSETS);
        }
    }
}

