/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.utilities.config.ProtoClassBasedSchemaProviderConfig;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.helpers.ProtoConversionUtil;
import org.apache.spark.api.java.JavaSparkContext;

public class ProtoClassBasedSchemaProvider
extends SchemaProvider {
    private final String schemaString;
    private transient Schema schema;

    public ProtoClassBasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME));
        String className = ConfigUtils.getStringWithAltKeys(this.config, ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME);
        boolean wrappedPrimitivesAsRecords = ConfigUtils.getBooleanWithAltKeys(props, ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS);
        int maxRecursionDepth = ConfigUtils.getIntWithAltKeys(props, ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_MAX_RECURSION_DEPTH);
        boolean timestampsAsRecords = ConfigUtils.getBooleanWithAltKeys(props, ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_TIMESTAMPS_AS_RECORDS);
        ProtoConversionUtil.SchemaConfig schemaConfig = new ProtoConversionUtil.SchemaConfig(wrappedPrimitivesAsRecords, maxRecursionDepth, timestampsAsRecords);
        try {
            this.schemaString = ProtoConversionUtil.getAvroSchemaForMessageClass(ReflectionUtils.getClass(className), schemaConfig).toString();
        }
        catch (Exception e) {
            throw new HoodieSchemaException(String.format("Error reading proto source schema for class: %s", className), e);
        }
    }

    @Override
    public Schema getSourceSchema() {
        if (this.schema == null) {
            try {
                Schema.Parser parser = new Schema.Parser();
                this.schema = parser.parse(this.schemaString);
            }
            catch (Exception e) {
                throw new HoodieSchemaException("Failed to parse schema: " + this.schemaString, e);
            }
        }
        return this.schema;
    }

    @Override
    public Schema getTargetSchema() {
        return this.getSourceSchema();
    }

    @Deprecated
    public static class Config {
        @Deprecated
        public static final ConfigProperty<String> PROTO_SCHEMA_CLASS_NAME = ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_CLASS_NAME;
        @Deprecated
        public static final ConfigProperty<Boolean> PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS = ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS;
        @Deprecated
        public static final ConfigProperty<Boolean> PROTO_SCHEMA_TIMESTAMPS_AS_RECORDS = ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_TIMESTAMPS_AS_RECORDS;
        @Deprecated
        public static final ConfigProperty<Integer> PROTO_SCHEMA_MAX_RECURSION_DEPTH = ProtoClassBasedSchemaProviderConfig.PROTO_SCHEMA_MAX_RECURSION_DEPTH;
    }
}

