/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.config.KafkaSourceConfig;
import org.apache.hudi.utilities.exception.HoodieSourceTimeoutException;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;
import org.apache.hudi.utilities.schema.KafkaOffsetPostProcessor;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class KafkaSource<T>
extends Source<JavaRDD<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSource.class);
    protected static final String NATIVE_KAFKA_KEY_DESERIALIZER_PROP = "key.deserializer";
    protected static final String NATIVE_KAFKA_VALUE_DESERIALIZER_PROP = "value.deserializer";
    protected static final String METRIC_NAME_KAFKA_MESSAGE_IN_COUNT = "kafkaMessageInCount";
    protected final HoodieIngestionMetrics metrics;
    protected final SchemaProvider schemaProvider;
    protected KafkaOffsetGen offsetGen;
    protected final boolean shouldAddOffsets;

    protected KafkaSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, Source.SourceType sourceType, HoodieIngestionMetrics metrics) {
        super(props, sparkContext, sparkSession, schemaProvider, sourceType);
        this.schemaProvider = schemaProvider;
        this.metrics = metrics;
        this.shouldAddOffsets = KafkaOffsetPostProcessor.Config.shouldAddOffsets(props);
    }

    @Override
    protected InputBatch<JavaRDD<T>> fetchNewData(Option<String> lastCheckpointStr, long sourceLimit) {
        try {
            OffsetRange[] offsetRanges = this.offsetGen.getNextOffsetRanges(lastCheckpointStr, sourceLimit, this.metrics);
            long totalNewMsgs = KafkaOffsetGen.CheckpointUtils.totalNewMessages(offsetRanges);
            LOG.info("About to read " + totalNewMsgs + " from Kafka for topic :" + this.offsetGen.getTopicName());
            if (totalNewMsgs <= 0L) {
                this.metrics.updateStreamerSourceNewMessageCount(METRIC_NAME_KAFKA_MESSAGE_IN_COUNT, 0L);
                return new InputBatch<JavaRDD<T>>(Option.empty(), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
            }
            this.metrics.updateStreamerSourceNewMessageCount(METRIC_NAME_KAFKA_MESSAGE_IN_COUNT, totalNewMsgs);
            JavaRDD<T> newDataRDD = this.toRDD(offsetRanges);
            return new InputBatch<JavaRDD<T>>(Option.of(newDataRDD), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
        }
        catch (TimeoutException e) {
            throw new HoodieSourceTimeoutException("Kafka Source timed out " + e.getMessage());
        }
    }

    abstract JavaRDD<T> toRDD(OffsetRange[] var1);

    @Override
    public void onCommit(String lastCkptStr) {
        if (ConfigUtils.getBooleanWithAltKeys(this.props, KafkaSourceConfig.ENABLE_KAFKA_COMMIT_OFFSET)) {
            this.offsetGen.commitOffsetToKafka(lastCkptStr);
        }
    }
}

