/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.utilities.sources.helpers.QueryInfo;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class SnapshotLoadQuerySplitter {
    protected final TypedProperties properties;

    public SnapshotLoadQuerySplitter(TypedProperties properties) {
        this.properties = properties;
    }

    public abstract Option<String> getNextCheckpoint(Dataset<Row> var1, String var2);

    public QueryInfo getNextCheckpoint(Dataset<Row> df, QueryInfo queryInfo) {
        return this.getNextCheckpoint(df, queryInfo.getStartInstant()).map(checkpoint -> queryInfo.withUpdatedEndInstant((String)checkpoint)).orElse(queryInfo);
    }

    public static Option<SnapshotLoadQuerySplitter> getInstance(TypedProperties props) {
        return props.getNonEmptyStringOpt("hoodie.deltastreamer.snapshotload.query.splitter.class.name", null).map(className -> (SnapshotLoadQuerySplitter)ReflectionUtils.loadClass(className, new Class[]{TypedProperties.class}, new Object[]{props}));
    }

    public static class Config {
        public static final String SNAPSHOT_LOAD_QUERY_SPLITTER_CLASS_NAME = "hoodie.deltastreamer.snapshotload.query.splitter.class.name";
    }
}

