/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.hudi.util.SparkKeyGenUtils;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class HoodieStreamerUtils {
    static Option<JavaRDD<HoodieRecord>> createHoodieRecords(HoodieStreamer.Config cfg, TypedProperties props, Option<JavaRDD<GenericRecord>> avroRDDOptional, SchemaProvider schemaProvider, HoodieRecord.HoodieRecordType recordType, boolean autoGenerateRecordKeys, String instantTime) {
        boolean shouldCombine = cfg.filterDupes != false || cfg.operation.equals((Object)WriteOperationType.UPSERT);
        Set<String> partitionColumns = HoodieStreamerUtils.getPartitionColumns(props);
        return avroRDDOptional.map(avroRDD -> {
            JavaRDD records;
            SerializableSchema avroSchema = new SerializableSchema(schemaProvider.getTargetSchema());
            SerializableSchema processedAvroSchema = new SerializableSchema(HoodieStreamerUtils.isDropPartitionColumns(props) != false ? HoodieAvroUtils.removeMetadataFields(avroSchema.get()) : avroSchema.get());
            if (recordType == HoodieRecord.HoodieRecordType.AVRO) {
                records = avroRDD.mapPartitions((FlatMapFunction & Serializable)genericRecordIterator -> {
                    if (autoGenerateRecordKeys) {
                        props.setProperty("_hoodie.record.key.gen.partition.id", String.valueOf(TaskContext.getPartitionId()));
                        props.setProperty("_hoodie.record.key.gen.instant.time", instantTime);
                    }
                    BuiltinKeyGenerator builtinKeyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator(props);
                    ArrayList<HoodieAvroRecord<HoodieRecordPayload>> avroRecords = new ArrayList<HoodieAvroRecord<HoodieRecordPayload>>();
                    while (genericRecordIterator.hasNext()) {
                        GenericRecord genRec = (GenericRecord)genericRecordIterator.next();
                        HoodieKey hoodieKey = new HoodieKey(builtinKeyGenerator.getRecordKey(genRec), builtinKeyGenerator.getPartitionPath(genRec));
                        GenericRecord gr = HoodieStreamerUtils.isDropPartitionColumns(props) != false ? HoodieAvroUtils.removeFields(genRec, partitionColumns) : genRec;
                        HoodieRecordPayload payload = shouldCombine ? DataSourceUtils.createPayload(cfg.payloadClassName, gr, (Comparable)HoodieAvroUtils.getNestedFieldVal(gr, cfg.sourceOrderingField, false, props.getBoolean(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), Boolean.parseBoolean(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue())))) : DataSourceUtils.createPayload(cfg.payloadClassName, gr);
                        avroRecords.add(new HoodieAvroRecord<HoodieRecordPayload>(hoodieKey, payload));
                    }
                    return avroRecords.iterator();
                });
            } else if (recordType == HoodieRecord.HoodieRecordType.SPARK) {
                records = avroRDD.mapPartitions((FlatMapFunction & Serializable)itr -> {
                    if (autoGenerateRecordKeys) {
                        props.setProperty("_hoodie.record.key.gen.partition.id", String.valueOf(TaskContext.getPartitionId()));
                        props.setProperty("_hoodie.record.key.gen.instant.time", instantTime);
                    }
                    BuiltinKeyGenerator builtinKeyGenerator = (BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator(props);
                    StructType baseStructType = AvroConversionUtils.convertAvroSchemaToStructType(processedAvroSchema.get());
                    StructType targetStructType = HoodieStreamerUtils.isDropPartitionColumns(props) != false ? AvroConversionUtils.convertAvroSchemaToStructType(HoodieAvroUtils.removeFields(processedAvroSchema.get(), partitionColumns)) : baseStructType;
                    HoodieAvroDeserializer deserializer = SparkAdapterSupport$.MODULE$.sparkAdapter().createAvroDeserializer(processedAvroSchema.get(), (DataType)baseStructType);
                    return new CloseableMappingIterator<GenericRecord, HoodieRecord>(ClosableIterator.wrap(itr), rec -> {
                        InternalRow row = (InternalRow)deserializer.deserialize(rec).get();
                        String recordKey = builtinKeyGenerator.getRecordKey(row, baseStructType).toString();
                        String partitionPath = builtinKeyGenerator.getPartitionPath(row, baseStructType).toString();
                        return new HoodieSparkRecord(new HoodieKey(recordKey, partitionPath), (InternalRow)HoodieInternalRowUtils.getCachedUnsafeProjection(baseStructType, targetStructType).apply(row), targetStructType, false);
                    });
                });
            } else {
                throw new UnsupportedOperationException(recordType.name());
            }
            return records;
        });
    }

    static Boolean isDropPartitionColumns(TypedProperties props) {
        return props.getBoolean(HoodieTableConfig.DROP_PARTITION_COLUMNS.key(), HoodieTableConfig.DROP_PARTITION_COLUMNS.defaultValue());
    }

    static Set<String> getPartitionColumns(TypedProperties props) {
        String partitionColumns = SparkKeyGenUtils.getPartitionColumns(props);
        return Arrays.stream(partitionColumns.split(",")).collect(Collectors.toSet());
    }
}

