/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.UUID;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.exception.HoodieTransformExecutionException;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatteningTransformer
implements Transformer {
    private static final String TMP_TABLE = "HUDI_SRC_TMP_TABLE_";
    private static final Logger LOG = LoggerFactory.getLogger(FlatteningTransformer.class);

    @Override
    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
        try {
            String tmpTable = TMP_TABLE.concat(UUID.randomUUID().toString().replace("-", "_"));
            LOG.info("Registering tmp table : " + tmpTable);
            rowDataset.createOrReplaceTempView(tmpTable);
            Dataset transformed = sparkSession.sql("select " + this.flattenSchema(rowDataset.schema(), null) + " from " + tmpTable);
            sparkSession.catalog().dropTempView(tmpTable);
            return transformed;
        }
        catch (Exception e) {
            throw new HoodieTransformExecutionException("Failed to apply flattening transformer", e);
        }
    }

    public String flattenSchema(StructType schema, String prefix) {
        StringBuilder selectSQLQuery = new StringBuilder();
        for (StructField field : schema.fields()) {
            String colName;
            String fieldName = field.name();
            String string = colName = prefix == null ? fieldName : prefix + "." + fieldName;
            if (field.dataType().getClass().equals(StructType.class)) {
                selectSQLQuery.append(this.flattenSchema((StructType)field.dataType(), colName));
            } else {
                selectSQLQuery.append(colName);
                selectSQLQuery.append(" as ");
                selectSQLQuery.append(colName.replace(".", "_"));
            }
            selectSQLQuery.append(",");
        }
        if (selectSQLQuery.length() > 0) {
            selectSQLQuery.deleteCharAt(selectSQLQuery.length() - 1);
        }
        return selectSQLQuery.toString();
    }
}

