/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u00181\u0001uB\u0001b\u000e\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0001\u000b\u0001BA\u0002\u0013\u0005\u0011\u000b\u0003\u0005W\u0001\t\u0005\r\u0011\"\u0001X\u0011!i\u0006A!A!B\u0013\u0011\u0006\"\u00020\u0001\t\u0003y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B3\t\u000f9\u0004!\u0019!C\u0001_\"11\u0010\u0001Q\u0001\nADq\u0001 \u0001C\u0002\u0013\u0005Q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002@\t\u0011\u0005\u0015\u0001A1A\u0005\u0002=Dq!a\u0002\u0001A\u0003%\u0001\u000fC\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\f!A\u00111\u0003\u0001!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u0016\u0001A)\u0019!C\u0001\u0003/A!\"a\u000b\u0001\u0011\u000b\u0007I\u0011AA\u0017\u0011%\t)\u0004\u0001EC\u0002\u0013\u0005q\u000eC\u0005\u00028\u0001A)\u0019!C\u0001_\"Q\u0011\u0011\b\u0001\t\u0006\u0004%\t!a\u000f\t\u0013\u0005%\u0003\u0001#b\u0001\n\u0003y\u0007BCA&\u0001!\u0015\r\u0011\"\u0001\u0002N!Q\u0011Q\u000b\u0001\t\u0006\u0004%\t!a\u0016\t\u0015\u0005}\u0003\u0001#b\u0001\n\u0003\ti\u0005C\u0005\u0002b\u0001A)\u0019!C\u0001_\"Q\u00111\r\u0001\t\u0006\u0004%\t!!\u001a\t\u0015\u0005M\u0004\u0001#b\u0001\n\u0003\t)\u0007\u0003\u0006\u0002v\u0001A)\u0019!C\u0001\u0003KB!\"a\u001e\u0001\u0011\u000b\u0007I\u0011AA3\u0011)\tI\b\u0001EC\u0002\u0013\u0005\u0011Q\r\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\t\t\n\u0001C\u0001\u0003\u0017Aq!a%\u0001\t\u0003\t)\nC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"I\u0011Q\u0016\u0001\u0012\u0002\u0013%\u0011q\u0016\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\tY\r\u0001C\u0005\u0003\u001b<q!!<1\u0011\u0003\tyO\u0002\u00040a!\u0005\u0011\u0011\u001f\u0005\u0007=&\"\t!a=\t\u0013\u0005U\u0018F1A\u0005\u0002\u0005]\b\u0002CA\u0000S\u0001\u0006I!!?\t\u000f\t\u0005\u0011\u0006\"\u0001\u0003\u0004!9!\u0011A\u0015\u0005\u0002\t-!A\u0005%p_\u0012LWmQ1uC2|w\rV1cY\u0016T!!\r\u001a\u0002\u000f\r\fG/\u00197pO*\u00111\u0007N\u0001\tG\u0006$\u0018\r\\=ti*\u0011QGN\u0001\u0004gFd'BA\u001c9\u0003\u0015\u0019\b/\u0019:l\u0015\tI$(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0010#\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\r\u0005s\u0017PU3g!\t)\u0005*D\u0001G\u0015\t9e'\u0001\u0005j]R,'O\\1m\u0013\tIeIA\u0004M_\u001e<\u0017N\\4\u0016\u0003-\u0003\"\u0001T'\u000e\u0003QJ!A\u0014\u001b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rM\u0004\u0018M]6!\u0003\u0015!\u0018M\u00197f+\u0005\u0011\u0006CA*U\u001b\u0005\u0001\u0014BA+1\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003%!\u0018M\u00197f?\u0012*\u0017\u000f\u0006\u0002Y7B\u0011q(W\u0005\u00035\u0002\u0013A!\u00168ji\"9A\fBA\u0001\u0002\u0004\u0011\u0016a\u0001=%c\u00051A/\u00192mK\u0002\na\u0001P5oSRtDc\u00011bEB\u00111\u000b\u0001\u0005\u0006o\u0019\u0001\ra\u0013\u0005\u0006!\u001a\u0001\rAU\u0001\u000bQ\u0006$wn\u001c9D_:4W#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001B2p]\u001aT!A\u001b\u001d\u0002\r!\fGm\\8q\u0013\tawMA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\fQ\u0006$wn\u001c9D_:4\u0007%\u0001\tdCR\fGn\\4UC\ndWMT1nKV\t\u0001\u000f\u0005\u0002rq:\u0011!O\u001e\t\u0003g\u0002k\u0011\u0001\u001e\u0006\u0003kr\na\u0001\u0010:p_Rt\u0014BA<A\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\u0004\u0015!E2bi\u0006dwn\u001a+bE2,g*Y7fA\u0005\t2-\u0019;bY><\u0007K]8qKJ$\u0018.Z:\u0016\u0003y\u0004B!]@qa&\u0019\u0011\u0011\u0001>\u0003\u00075\u000b\u0007/\u0001\ndCR\fGn\\4Qe>\u0004XM\u001d;jKN\u0004\u0013!\u0004;bE2,Gj\\2bi&|g.\u0001\buC\ndW\rT8dCRLwN\u001c\u0011\u0002#!|w\u000eZ5f)\u0006\u0014G.Z#ySN$8/\u0006\u0002\u0002\u000eA\u0019q(a\u0004\n\u0007\u0005E\u0001IA\u0004C_>dW-\u00198\u0002%!|w\u000eZ5f)\u0006\u0014G.Z#ySN$8\u000fI\u0001\u000b[\u0016$\u0018m\u00117jK:$XCAA\r!\u0011\tY\"a\n\u000e\u0005\u0005u!b\u0001)\u0002 )!\u0011\u0011EA\u0012\u0003\u0019\u0019w.\\7p]*\u0019\u0011Q\u0005\u001d\u0002\t!,H-[\u0005\u0005\u0003S\tiBA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\u0002\u0017Q\f'\r\\3D_:4\u0017nZ\u000b\u0003\u0003_\u0001B!a\u0007\u00022%!\u00111GA\u000f\u0005EAun\u001c3jKR\u000b'\r\\3D_:4\u0017nZ\u0001\ni\u0006\u0014G.\u001a(b[\u0016\fA\u0002Z1uC\n\f7/\u001a(b[\u0016\f\u0011\u0002^1cY\u0016$\u0016\u0010]3\u0016\u0005\u0005u\u0002\u0003BA \u0003\u000bj!!!\u0011\u000b\t\u0005\r\u0013qD\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u000f\n\tEA\bI_>$\u0017.\u001a+bE2,G+\u001f9f\u00035!\u0018M\u00197f)f\u0004XMT1nK\u0006Y\u0001O]5nCJL8*Z=t+\t\ty\u0005\u0005\u0003@\u0003#\u0002\u0018bAA*\u0001\n)\u0011I\u001d:bs\u0006i\u0001O]3D_6\u0014\u0017N\\3LKf,\"!!\u0017\u0011\t}\nY\u0006]\u0005\u0004\u0003;\u0002%AB(qi&|g.A\bqCJ$\u0018\u000e^5p]\u001aKW\r\u001c3t\u00039\u0011\u0017m]3GS2,gi\u001c:nCR\f1\u0002^1cY\u0016\u001c6\r[3nCV\u0011\u0011q\r\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e\u001b\u0002\u000bQL\b/Z:\n\t\u0005E\u00141\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001\b;bE2,7k\u00195f[\u0006<\u0016\u000e\u001e5pkRlU\r^1GS\u0016dGm]\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017a\u00073bi\u0006\u001c6\r[3nC^KG\u000f[8vi6+G/\u0019$jK2$7/A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0003E9W\r\u001e)beRLG/[8o!\u0006$\bn]\u000b\u0003\u0003\u007f\u0002R!!!\u0002\fBtA!a!\u0002\b:\u00191/!\"\n\u0003\u0005K1!!#A\u0003\u001d\u0001\u0018mY6bO\u0016LA!!$\u0002\u0010\n\u00191+Z9\u000b\u0007\u0005%\u0005)\u0001\njgB\u000b'\u000f^5uS>tW\r\u001a+bE2,\u0017aD5oSRDun\u001c3jKR\u000b'\r\\3\u0015\u0003a\u000bQ\u0003]1sg\u0016\u001c6\r[3nC\u0006sGmQ8oM&<7\u000f\u0006\u0002\u0002\u001cB1q(!(\u0002hyL1!a(A\u0005\u0019!V\u000f\u001d7fe\u0005\u0001R\r\u001f;sCR\u000b'\r\\3D_:4\u0017n\u001a\u000b\u0006}\u0006\u0015\u0016\u0011\u0016\u0005\b\u0003O#\u0003\u0019AA\u0007\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\t\u0011\u0005-F\u0005%AA\u0002y\f\u0011c\u001c:jO&tG+\u00192mK\u000e{gNZ5h\u0003i)\u0007\u0010\u001e:b)\u0006\u0014G.Z\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tLK\u0002\u007f\u0003g[#!!.\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f\u0003\u0015AC1o]>$\u0018\r^5p]&!\u00111YA]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cY>\fG\rV1cY\u0016\u001c6\r[3nC\nKX*\u001a;b\u00072LWM\u001c;\u0015\u0005\u0005%\u0007#B \u0002\\\u0005\u001d\u0014\u0001\u0005<fe&4\u0017\u0010R1uCN\u001b\u0007.Z7b)\u001dA\u0016qZAn\u0003GDq!!5(\u0001\u0004\t\u0019.A\buC\ndW-\u00133f]RLg-[3s!\u0011\t).a6\u000e\u0003IJ1!!73\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBA\u001dO\u0001\u0007\u0011Q\u001c\t\u0004'\u0006}\u0017bAAqa\t\u00012)\u0019;bY><G+\u00192mKRK\b/\u001a\u0005\b\u0003k:\u0003\u0019AAs!\u0019\t\t)a#\u0002hB!\u0011\u0011NAu\u0013\u0011\tY/a\u001b\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u0013\u0011>|G-[3DCR\fGn\\4UC\ndW\r\u0005\u0002TSM\u0011\u0011F\u0010\u000b\u0003\u0003_\fqB\\3fI\u001aKG\u000e^3s!J|\u0007o]\u000b\u0003\u0003s\u0004R!!!\u0002|BLA!!@\u0002\u0010\n!A*[:u\u0003AqW-\u001a3GS2$XM\u001d)s_B\u001c\b%A\u0003baBd\u0017\u0010F\u0003a\u0005\u000b\u0011I\u0001\u0003\u0004\u0003\b5\u0002\raS\u0001\rgB\f'o[*fgNLwN\u001c\u0005\b\u0003#l\u0003\u0019AAj)\u0015\u0001'Q\u0002B\b\u0011\u0019\u00119A\fa\u0001\u0017\"1!\u0011\u0003\u0018A\u0002I\u000bAbY1uC2|w\rV1cY\u0016\u0004")
public class HoodieCatalogTable
implements Logging {
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private String databaseName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private String baseFileFormat;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType dataSchemaWithoutMetaFields;
    private StructType partitionSchema;
    private final SparkSession spark;
    private CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public static List<String> needFilterProps() {
        return HoodieCatalogTable$.MODULE$.needFilterProps();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    public void table_$eq(CatalogTable x$1) {
        this.table = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.hadoopConf()).build();
                this.bitmap$0 |= 1;
            }
        }
        return this.metaClient;
    }

    public HoodieTableMetaClient metaClient() {
        return (this.bitmap$0 & 1) == 0 ? this.metaClient$lzycompute() : this.metaClient;
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
        }
        return this.tableConfig;
    }

    public HoodieTableConfig tableConfig() {
        return (this.bitmap$0 & 2) == 0 ? this.tableConfig$lzycompute() : this.tableConfig;
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
        }
        return this.tableName;
    }

    public String tableName() {
        return (this.bitmap$0 & 4) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private String databaseName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.databaseName = this.tableConfig().getDatabaseName();
                this.bitmap$0 |= 8;
            }
        }
        return this.databaseName;
    }

    public String databaseName() {
        return (this.bitmap$0 & 8) == 0 ? this.databaseName$lzycompute() : this.databaseName;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableType;
    }

    public HoodieTableType tableType() {
        return (this.bitmap$0 & 0x10) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.tableTypeName;
    }

    public String tableTypeName() {
        return (this.bitmap$0 & 0x20) == 0 ? this.tableTypeName$lzycompute() : this.tableTypeName;
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.primaryKeys;
    }

    public String[] primaryKeys() {
        return (this.bitmap$0 & 0x40) == 0 ? this.primaryKeys$lzycompute() : this.primaryKeys;
    }

    private Option<String> preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.preCombineKey;
    }

    public Option<String> preCombineKey() {
        return (this.bitmap$0 & 0x80) == 0 ? this.preCombineKey$lzycompute() : this.preCombineKey;
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.partitionFields;
    }

    public String[] partitionFields() {
        return (this.bitmap$0 & 0x100) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    private String baseFileFormat$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.baseFileFormat = this.metaClient().getTableConfig().getBaseFileFormat().name();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.baseFileFormat;
    }

    public String baseFileFormat() {
        return (this.bitmap$0 & 0x200) == 0 ? this.baseFileFormat$lzycompute() : this.baseFileFormat;
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                StructType structType;
                Option<StructType> schemaFromMetaOpt = this.loadTableSchemaByMetaClient();
                if (schemaFromMetaOpt.nonEmpty()) {
                    structType = (StructType)schemaFromMetaOpt.get();
                } else if (this.table().schema().nonEmpty()) {
                    structType = HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
                } else {
                    throw new AnalysisException(new StringBuilder(33).append(this.catalogTableName()).append(" does not contains schema fields.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                this.tableSchema = structType;
                this.bitmap$0 |= 0x400;
            }
        }
        return this.tableSchema;
    }

    public StructType tableSchema() {
        return (this.bitmap$0 & 0x400) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.tableSchemaWithoutMetaFields;
    }

    public StructType tableSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x800) == 0 ? this.tableSchemaWithoutMetaFields$lzycompute() : this.tableSchemaWithoutMetaFields;
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$dataSchema$1(this, f))));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.dataSchema$lzycompute() : this.dataSchema;
    }

    private StructType dataSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.dataSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.dataSchema());
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.dataSchemaWithoutMetaFields;
    }

    public StructType dataSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.dataSchemaWithoutMetaFields$lzycompute() : this.dataSchemaWithoutMetaFields;
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$partitionSchema$1(this, f))));
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        java.util.List<String> droppedPartitions = TimelineUtils.getDroppedPartitions(this.metaClient().getActiveTimeline());
        return (Seq)HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$getPartitionPaths$1(droppedPartitions, x$2)));
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public void initHoodieTable() {
        block5: {
            block4: {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initHoodieTable$1(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable ), ()Ljava/lang/String;)((HoodieCatalogTable)this));
                var4_1 = this.parseSchemaAndConfigs();
                if (var4_1 == null) {
                    throw new MatchError(var4_1);
                }
                finalSchema = (StructType)var4_1._1();
                tableConfigs = (scala.collection.immutable.Map)var4_1._2();
                var2_4 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
                var3_5 = var2_4;
                finalSchema = (StructType)var3_5._1();
                tableConfigs = (scala.collection.immutable.Map)var3_5._2();
                dataSchema = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(finalSchema);
                qual$1 = this.table();
                x$1 = finalSchema;
                x$2 = qual$1.copy$default$1();
                x$3 = qual$1.copy$default$2();
                x$4 = qual$1.copy$default$3();
                x$5 = qual$1.copy$default$5();
                x$6 = qual$1.copy$default$6();
                x$7 = qual$1.copy$default$7();
                x$8 = qual$1.copy$default$8();
                x$9 = qual$1.copy$default$9();
                x$10 = qual$1.copy$default$10();
                x$11 = qual$1.copy$default$11();
                x$12 = qual$1.copy$default$12();
                x$13 = qual$1.copy$default$13();
                x$14 = qual$1.copy$default$14();
                x$15 = qual$1.copy$default$15();
                x$16 = qual$1.copy$default$16();
                x$17 = qual$1.copy$default$17();
                x$18 = qual$1.copy$default$18();
                x$19 = qual$1.copy$default$19();
                x$20 = qual$1.copy$default$20();
                this.table_$eq(qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
                properties = TypedProperties.fromMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs).asJava());
                catalogDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$initHoodieTable$2(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable ), ()Ljava/lang/String;)((HoodieCatalogTable)this)));
                if (!this.hoodieTableExists()) break block4;
                if (StringUtils.isNullOrEmpty(this.databaseName())) ** GOTO lbl-1000
                v0 = this.databaseName();
                var35_32 = catalogDatabaseName;
                if (!(v0 != null ? v0.equals(var35_32) == false : var35_32 != null)) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                ValidationUtils.checkArgument(v1, "The database names from this hoodie path and this catalog table is not same.");
                recordName = AvroSchemaUtils.getAvroRecordQualifiedName(this.table().identifier().table());
                x$21 = dataSchema;
                x$22 = recordName;
                x$23 = SchemaConverters$.MODULE$.toAvroType$default$2();
                x$24 = SchemaConverters$.MODULE$.toAvroType$default$4();
                HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(catalogDatabaseName).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)x$21, x$23, x$22, x$24).toString()).initTable(this.hadoopConf(), this.tableLocation());
                break block5;
            }
            var42_38 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
            if (var42_38 == null) {
                throw new MatchError(var42_38);
            }
            recordName = (String)var42_38._1();
            namespace = (String)var42_38._2();
            var1_41 = new Tuple2((Object)recordName, (Object)namespace);
            var41_42 = var1_41;
            recordName = (String)var41_42._1();
            namespace = (String)var41_42._2();
            schema = SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, recordName, namespace);
            partitionColumns = this.table().partitionColumnNames().isEmpty() != false ? null : this.table().partitionColumnNames().mkString(",");
            HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(catalogDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema.toString()).setPartitionFields(partitionColumns).initTable(this.hadoopConf(), this.tableLocation());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
        globalSqlOptions = HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(globalTableConfigs);
        sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions(this.catalogProperties())));
        var9_5 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
        if (var9_5 == null) ** GOTO lbl-1000
        var10_6 = (CatalogTableType)var9_5._1();
        var11_7 = var9_5._2$mcZ$sp();
        v0 = CatalogTableType$.MODULE$.EXTERNAL();
        var12_8 = var10_6;
        if (!(v0 != null ? v0.equals(var12_8) == false : var12_8 != null) && var11_7) {
            existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
            catalogTableProps = HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(this.catalogProperties());
            HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
            options = this.extraTableConfig(this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
            var2_13 = new Tuple2((Object)this.tableSchema(), (Object)options);
        } else if (var9_5 != null && !(var17_14 = var9_5._2$mcZ$sp())) {
            ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.table().schema();
            options = this.extraTableConfig(false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions));
            var2_13 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema), (Object)options);
        } else {
            if (var9_5 != null) {
                var20_17 = (CatalogTableType)var9_5._1();
                var21_18 = var9_5._2$mcZ$sp();
                v1 = CatalogTableType$.MODULE$.MANAGED();
                var22_19 = var20_17;
                if (!(v1 != null ? v1.equals(var22_19) == false : var22_19 != null) && var21_18) {
                    throw new AnalysisException(new StringBuilder(81).append("Can not create the managed table('").append(this.catalogTableName()).append("')").append(". The associated location('").append(this.tableLocation()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            throw new MatchError((Object)var9_5);
        }
        var8_20 = var2_13;
        if (var8_20 == null) {
            throw new MatchError((Object)var8_20);
        }
        finalSchema = (StructType)var8_20._1();
        tableConfigs = (scala.collection.immutable.Map)var8_20._2();
        var1_23 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        var7_24 = var1_23;
        finalSchema = (StructType)var7_24._1();
        tableConfigs = (scala.collection.immutable.Map)var7_24._2();
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema, HoodieOptionConfig$.MODULE$.mapHoodieConfigsToSqlOptions((scala.collection.immutable.Map<String, String>)tableConfigs));
        resolver = this.spark().sessionState().conf().resolver();
        dataSchema = (Seq)finalSchema.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseSchemaAndConfigs$1$adapted(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable scala.Function2 org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((HoodieCatalogTable)this, (Function2)resolver));
        this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema);
        return new Tuple2((Object)finalSchema, (Object)tableConfigs);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(boolean tableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (tableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            String primaryKeys = this.table().properties().getOrElse((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName(), (Function0 & Serializable & scala.Serializable)() -> this.table().storage().properties().get((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName())).toString();
            String partitions = this.table().partitionColumnNames().mkString(",");
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)DataSourceOptionsHelper$.MODULE$.inferKeyGenClazz(primaryKeys, partitions));
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StructType> loadTableSchemaByMetaClient() {
        None$ none$;
        Function2 resolver2 = this.spark().sessionState().conf().resolver();
        try {
            none$ = HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).map((Function1 & Serializable & scala.Serializable)originSchema -> {
                Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                    void var3_7;
                    boolean x$1 = true;
                    String x$2 = f.copy$default$1();
                    DataType x$3 = f.copy$default$2();
                    Metadata x$4 = f.copy$default$4();
                    StructField nullableField = f.copy(x$2, x$3, x$1, x$4);
                    Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.table().schema(), nullableField.name(), (Function2<String, String, Object>)resolver2);
                    return catalogField.isDefined() ? (StructField)((StructField)catalogField.get()).getComment().map((Function1 & Serializable & scala.Serializable)comment -> nullableField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> nullableField) : var3_7;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).partition((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$loadTableSchemaByMetaClient$5(this, f)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField[] partFields = (StructField[])tuple2._1();
                StructField[] dataFields = (StructField[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)partFields, (Object)dataFields);
                Tuple2 tuple23 = tuple22;
                StructField[] partFields2 = (StructField[])tuple23._1();
                StructField[] dataFields2 = (StructField[])tuple23._2();
                scala.collection.immutable.Map nameToField = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFields2)).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), field), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                Seq orderedPartFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionFields())).map((Function1 & Serializable & scala.Serializable)x$8 -> (StructField)nameToField.apply(x$8), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).toSeq();
                return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFields2)).$plus$plus((GenTraversableOnce)orderedPartFields, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            });
        }
        catch (Throwable cause) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load table schema from meta client.", cause);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema) {
        block0: {
            CatalogTableType catalogTableType = tableType;
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2))) break block0;
            Seq invalidChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ":", ";"}));
            dataSchema.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HoodieCatalogTable.$anonfun$verifyDataSchema$4(tableIdentifier, invalidChars, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$partitionSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionPaths$1(java.util.List droppedPartitions$1, String x$2) {
        return !droppedPartitions$1.contains(x$2);
    }

    public static final /* synthetic */ String $anonfun$initHoodieTable$1(HoodieCatalogTable $this) {
        return new StringBuilder(27).append("Init hoodie.properties for ").append($this.table().identifier().unquotedString()).toString();
    }

    public static final /* synthetic */ String $anonfun$initHoodieTable$2(HoodieCatalogTable $this) {
        return $this.spark().sessionState().catalog().getCurrentDatabase();
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$2(Function2 resolver$1, StructField f$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$6, (Object)f$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$1(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return $this.table().partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$2(resolver$1, f, x$6)));
    }

    public static final /* synthetic */ boolean $anonfun$loadTableSchemaByMetaClient$5(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$verifyDataSchema$2(StructField f$2, CharSequence x$1) {
        return f$2.name().contains(x$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$1(Seq invalidChars$1, TableIdentifier tableIdentifier$1, StructField f) {
        DataType dataType = f.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (invalidChars$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$verifyDataSchema$2(f, x$1)))) {
                String invalidCharsString = ((TraversableOnce)invalidChars$1.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append((String)c).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String errMsg = new StringBuilder(123).append("Cannot create a table having a nested column whose name contains ").append("invalid characters (").append(invalidCharsString).append(") in Hive metastore. Table: ").append(tableIdentifier$1).append("; ").append("Column: ").append(f.name()).toString();
                throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void verifyNestedColumnNames$1(StructType schema, Seq invalidChars$1, TableIdentifier tableIdentifier$1) {
        schema.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HoodieCatalogTable.$anonfun$verifyDataSchema$1(invalidChars$1, tableIdentifier$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$4(TableIdentifier tableIdentifier$1, Seq invalidChars$1, StructField f) {
        DataType dataType = f.dataType();
        if (f.name().contains(",")) {
            throw new AnalysisException(new StringBuilder(101).append("Cannot create a table having a column whose name ").append("contains commas in Hive metastore. Table: ").append(tableIdentifier$1).append("; Column: ").append(f.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.$init$((Logging)this);
        Object object = this.table().provider().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        ValidationUtils.checkArgument(!(object != null ? !object.equals(string) : string != null), new StringBuilder(21).append(" ").append(this.table().qualifiedName()).append(" is not a Hudi table").toString());
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = this.table().qualifiedName();
        this.catalogProperties = HoodieOptionConfig$.MODULE$.makeOptionsCaseInsensitive((scala.collection.immutable.Map<String, String>)this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties()));
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(this.table(), spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }

    public static final /* synthetic */ Object $anonfun$parseSchemaAndConfigs$1$adapted(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$1($this, resolver$1, f));
    }
}

