/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.cli.BootstrapExecutorUtils;
import org.apache.hudi.cli.HDFSParquetImporterUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunBootstrapProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A\u0001E\t\u0001A!)a\u0006\u0001C\u0001_!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0004B\u0002\u001f\u0001A\u0003%1\u0007C\u0004>\u0001\t\u0007I\u0011\u0002 \t\r\u0015\u0003\u0001\u0015!\u0003@\u0011\u00151\u0005\u0001\"\u00013\u0011\u00159\u0005\u0001\"\u0001?\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015y\u0006\u0001\"\u0011a\u000f\u0015\t\u0017\u0003#\u0001c\r\u0015\u0001\u0012\u0003#\u0001d\u0011\u0015q3\u0002\"\u0001h\u0011\u001dA7B1A\u0005\u0002%DaA]\u0006!\u0002\u0013Q\u0007\"B:\f\t\u0003!(!\u0006*v]\n{w\u000e^:ue\u0006\u0004\bK]8dK\u0012,(/\u001a\u0006\u0003%M\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t!R#A\u0004d_6l\u0017M\u001c3\u000b\u0005Y9\u0012\u0001\u00025vI&T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0011&QA\u0011!eI\u0007\u0002#%\u0011A%\u0005\u0002\u000e\u0005\u0006\u001cX\r\u0015:pG\u0016$WO]3\u0011\u0005\t2\u0013BA\u0014\u0012\u0005A\u0001&o\\2fIV\u0014XMQ;jY\u0012,'\u000f\u0005\u0002*Y5\t!F\u0003\u0002,3\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002.U\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00011!\t\u0011\u0003!\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012a\r\t\u0004i]JT\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\tR\u0014BA\u001e\u0012\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000bI\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011u#A\u0003usB,7/\u0003\u0002E\u0003\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019=+F\u000bU+U?RK\u0006+\u0012\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\fAaY1mYR\u0011!J\u0017\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tyu$\u0001\u0004=e>|GOP\u0005\u0002m%\u0011!+N\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0002TKFT!AU\u001b\u0011\u0005]CV\"A\f\n\u0005e;\"a\u0001*po\")1\f\u0003a\u00019\u0006!\u0011M]4t!\t\u0011S,\u0003\u0002_#\ti\u0001K]8dK\u0012,(/Z!sON\fQAY;jY\u0012,\u0012\u0001M\u0001\u0016%Vt'i\\8ugR\u0014\u0018\r\u001d)s_\u000e,G-\u001e:f!\t\u00113b\u0005\u0002\fIB\u0011A'Z\u0005\u0003MV\u0012a!\u00118z%\u00164G#\u00012\u0002\t9\u000bU*R\u000b\u0002UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0005Y\u0006twMC\u0001p\u0003\u0011Q\u0017M^1\n\u0005Ed'AB*ue&tw-A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0003U\u00042A^>&\u001b\u00059(B\u0001=z\u0003!1WO\\2uS>t'B\u0001>o\u0003\u0011)H/\u001b7\n\u0005q<(\u0001C*vaBd\u0017.\u001a:")
public class RunBootstrapProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RunBootstrapProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunBootstrapProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String tableType = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get();
        String bootstrapPath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get();
        String basePath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[3]).get();
        String rowKeyField = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).get();
        String baseFileFormat = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[5]).get();
        String partitionPathField = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[6]).get();
        String bootstrapIndexClass = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[7]).get();
        String selectorClass = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[8]).get();
        String keyGeneratorClass = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[9]).get();
        String fullBootstrapInputProvider = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[10]).get();
        String schemaProviderClass = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[11]).get();
        String payloadClass = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[12]).get();
        int parallelism = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[13]).get());
        boolean enableHiveSync = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[14]).get());
        String propsFilePath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[15]).get();
        boolean bootstrapOverwrite = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[16]).get());
        Option<Object> options = this.getArgValueOrDefault(args2, this.PARAMETERS()[17]);
        Tuple2<String, Option<String>> tuple2 = HoodieCLIUtils$.MODULE$.getTableIdentifier((String)table.get());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String tableName = (String)tuple2._1();
        Option database = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)tableName, (Object)database);
        Tuple2 tuple23 = tuple22;
        String tableName2 = (String)tuple23._1();
        Option database2 = (Option)tuple23._2();
        ArrayList<String> configs = new ArrayList<String>();
        TypedProperties properties = propsFilePath == null || propsFilePath.isEmpty() ? HDFSParquetImporterUtils.buildProperties(configs) : HDFSParquetImporterUtils.readConfig(this.jsc().hadoopConfiguration(), new Path(propsFilePath), configs).getProps(true);
        properties.setProperty(HoodieBootstrapConfig.BASE_PATH.key(), bootstrapPath);
        if (bootstrapPath.equals(basePath)) {
            throw new IllegalArgumentException("bootstrap_path and base_path must be different");
        }
        Object object = !StringUtils.isNullOrEmpty(keyGeneratorClass) && KeyGeneratorType.getNames().contains(keyGeneratorClass.toUpperCase(Locale.ROOT)) ? properties.setProperty(HoodieWriteConfig.KEYGENERATOR_TYPE.key(), keyGeneratorClass.toUpperCase(Locale.ROOT)) : properties.setProperty(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), keyGeneratorClass);
        properties.setProperty(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.key(), fullBootstrapInputProvider);
        properties.setProperty(HoodieBootstrapConfig.PARALLELISM_VALUE.key(), ((Object)BoxesRunTime.boxToInteger((int)parallelism)).toString());
        properties.setProperty(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), selectorClass);
        properties.setProperty(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), rowKeyField);
        properties.setProperty(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), partitionPathField);
        FileSystem fs = FSUtils.getFs(basePath, this.jsc().hadoopConfiguration());
        BootstrapExecutorUtils.Config cfg = new BootstrapExecutorUtils.Config();
        cfg.setTableName(tableName2);
        cfg.setDatabase((String)database2.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.sparkSession().sessionState().catalog().getCurrentDatabase()));
        cfg.setTableType(tableType);
        cfg.setBasePath(basePath);
        cfg.setBaseFileFormat(baseFileFormat);
        cfg.setBootstrapIndexClass(bootstrapIndexClass);
        cfg.setSchemaProviderClass(schemaProviderClass);
        cfg.setPayloadClass(payloadClass);
        cfg.setEnableHiveSync(Predef$.MODULE$.boolean2Boolean(enableHiveSync));
        cfg.setBootstrapOverwrite(Predef$.MODULE$.boolean2Boolean(bootstrapOverwrite));
        TypedProperties.putAll(properties, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.spark().sqlContext().conf().getAllConfs()).asJava());
        Option<Object> option = options;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object p = some.value();
            scala.collection.immutable.Map<String, String> paramPairs = HoodieCLIUtils$.MODULE$.extractOptions((String)p);
            paramPairs.foreach((Function1 & Serializable & scala.Serializable)pair -> properties.setProperty((String)pair._1(), (String)pair._2()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No options");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        new BootstrapExecutorUtils(cfg, this.jsc(), fs, this.jsc().hadoopConfiguration(), properties).execute();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))}));
    }

    @Override
    public RunBootstrapProcedure build() {
        return new RunBootstrapProcedure();
    }

    public RunBootstrapProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.required(1, "table_type", DataTypes.StringType), ProcedureParameter$.MODULE$.required(2, "bootstrap_path", DataTypes.StringType), ProcedureParameter$.MODULE$.required(3, "base_path", DataTypes.StringType), ProcedureParameter$.MODULE$.required(4, "rowKey_field", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(5, "base_file_format", DataTypes.StringType, "PARQUET"), ProcedureParameter$.MODULE$.optional(6, "partition_path_field", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(7, "bootstrap_index_class", DataTypes.StringType, "org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex"), ProcedureParameter$.MODULE$.optional(8, "selector_class", DataTypes.StringType, "org.apache.hudi.client.bootstrap.selector.MetadataOnlyBootstrapModeSelector"), ProcedureParameter$.MODULE$.optional(9, "key_generator_class", DataTypes.StringType, "org.apache.hudi.keygen.SimpleKeyGenerator"), ProcedureParameter$.MODULE$.optional(10, "full_bootstrap_input_provider", DataTypes.StringType, "org.apache.hudi.bootstrap.SparkParquetBootstrapDataProvider"), ProcedureParameter$.MODULE$.optional(11, "schema_provider_class", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(12, "payload_class", DataTypes.StringType, "org.apache.hudi.common.model.OverwriteWithLatestAvroPayload"), ProcedureParameter$.MODULE$.optional(13, "parallelism", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)1500)), ProcedureParameter$.MODULE$.optional(14, "enable_hive_sync", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(15, "props_file_path", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(16, "bootstrap_overwrite", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(17, "options", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("status", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
    }
}

