/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowFsPathDetailProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\t\u0013\u0001\u0005BQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00048\u0001\u0001\u0006IA\f\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019\u0001\u0005\u0001)A\u0005u!)\u0011\t\u0001C\u0001[!)!\t\u0001C\u0001s!)1\t\u0001C!\t\")!\f\u0001C\u00017\")\u0011\u000e\u0001C!U\u001e)aN\u0005E\u0001_\u001a)\u0011C\u0005E\u0001a\")\u0011\u0006\u0004C\u0001i\"9Q\u000f\u0004b\u0001\n\u00031\bB\u0002@\rA\u0003%q\u000f\u0003\u0004\u0000\u0019\u0011\u0005\u0011\u0011\u0001\u0002\u001a'\"|wOR:QCRDG)\u001a;bS2\u0004&o\\2fIV\u0014XM\u0003\u0002\u0014)\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005U1\u0012aB2p[6\fg\u000e\u001a\u0006\u0003/a\tA\u0001[;eS*\u0011\u0011DG\u0001\u0004gFd'BA\u000e\u001d\u0003\u0015\u0019\b/\u0019:l\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\t\u0014\u0011\u0005\r\"S\"\u0001\n\n\u0005\u0015\u0012\"!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002$O%\u0011\u0001F\u0005\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\fa\u0001P5oSRtD#A\u0016\u0011\u0005\r\u0002\u0011A\u0003)B%\u0006kU\tV#S'V\ta\u0006E\u00020eQj\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003GUJ!A\u000e\n\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006%A\u0006P+R\u0003V\u000bV0U3B+U#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uB\u0012!\u0002;za\u0016\u001c\u0018BA =\u0005)\u0019FO];diRK\b/Z\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\tI\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018AC8viB,H\u000fV=qK\u0006!1-\u00197m)\t)U\u000bE\u0002G\u001dFs!a\u0012'\u000f\u0005![U\"A%\u000b\u0005)\u0003\u0013A\u0002\u001fs_>$h(C\u00012\u0013\ti\u0005'A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0003&aA*fc*\u0011Q\n\r\t\u0003%Nk\u0011\u0001G\u0005\u0003)b\u00111AU8x\u0011\u00151\u0006\u00021\u0001X\u0003\u0011\t'oZ:\u0011\u0005\rB\u0016BA-\u0013\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\u0006Yq-\u001a;GS2,7+\u001b>f)\taF\r\u0005\u0002^C:\u0011al\u0018\t\u0003\u0011BJ!\u0001\u0019\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003ABBQ!Z\u0005A\u0002\u0019\fAa]5{KB\u0011qfZ\u0005\u0003QB\u0012A\u0001T8oO\u0006)!-^5mIV\t1\u000e\u0005\u0002$Y&\u0011QN\u0005\u0002\n!J|7-\u001a3ve\u0016\f\u0011d\u00155po\u001a\u001b\b+\u0019;i\t\u0016$\u0018-\u001b7Qe>\u001cW\rZ;sKB\u00111\u0005D\n\u0003\u0019E\u0004\"a\f:\n\u0005M\u0004$AB!osJ+g\rF\u0001p\u0003\u0011q\u0015)T#\u0016\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\t1\fgn\u001a\u0006\u0002y\u0006!!.\u0019<b\u0013\t\u0011\u00170A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0005\u0005\r\u0001#BA\u0003\u0003\u001f1SBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0011\u0019,hn\u0019;j_:T1!!\u0004|\u0003\u0011)H/\u001b7\n\t\u0005E\u0011q\u0001\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class ShowFsPathDetailProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "path", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "is_sub", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(2, "sort", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true))});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("path_num", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("file_num", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("storage_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("storage_size(unit)", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("storage_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("space_consumed", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("quota", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("space_quota", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowFsPathDetailProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowFsPathDetailProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        String srcPath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[0]).get();
        boolean isSub = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get());
        boolean sort = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get());
        Path path = new Path(srcPath);
        FileSystem fs = FSUtils.getFs(path, this.jsc().hadoopConfiguration());
        FileStatus[] status = isSub ? fs.listStatus(path) : fs.globStatus(path);
        ArrayList rows = new ArrayList();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])status)).nonEmpty()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])status)).indices().foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
                ContentSummary summary = fs.getContentSummary(status[i].getPath());
                String storagePath = status[i].getPath().toString();
                return rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)summary.getDirectoryCount()), BoxesRunTime.boxToLong((long)summary.getFileCount()), BoxesRunTime.boxToLong((long)summary.getLength()), this.getFileSize(summary.getLength()), storagePath, BoxesRunTime.boxToLong((long)summary.getQuota()), BoxesRunTime.boxToLong((long)summary.getSpaceConsumed()), BoxesRunTime.boxToLong((long)summary.getSpaceQuota())})));
            });
        }
        Dataset df = this.spark().sqlContext().createDataFrame(rows, this.OUTPUT_TYPE());
        return sort ? Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("storage_size").desc()})).collect()) : Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("file_num").desc()})).collect());
    }

    public String getFileSize(long size) {
        int GB = 0x40000000;
        int MB = 0x100000;
        int KB = 1024;
        DecimalFormat df = new DecimalFormat("0.00");
        String resultSize = size / (long)GB >= 1L ? new StringBuilder(2).append(df.format((float)((double)size / (double)GB))).append("GB").toString() : (size / (long)MB >= 1L ? new StringBuilder(2).append(df.format((float)((double)size / (double)MB))).append("MB").toString() : (size / (long)KB >= 1L ? new StringBuilder(2).append(df.format((float)((double)size / (double)KB))).append("KB").toString() : new StringBuilder(1).append(size).append("B").toString()));
        return resultSize;
    }

    @Override
    public Procedure build() {
        return new ShowFsPathDetailProcedure();
    }
}

