/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.protobuf;

import io.confluent.kafka.formatter.SchemaMessageReader;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import java.io.BufferedReader;
import org.apache.hudi.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hudi.com.google.protobuf.Message;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class ProtobufMessageReader
extends SchemaMessageReader<Message> {
    public ProtobufMessageReader() {
    }

    ProtobufMessageReader(SchemaRegistryClient schemaRegistryClient, ProtobufSchema keySchema, ProtobufSchema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean autoRegister) {
        super(schemaRegistryClient, (ParsedSchema)keySchema, (ParsedSchema)valueSchema, topic, parseKey, reader, autoRegister);
    }

    @Override
    protected SchemaMessageSerializer<Message> createSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, Serializer keySerializer) {
        return new ProtobufMessageSerializer(schemaRegistryClient, autoRegister, keySerializer);
    }

    @Override
    protected SchemaProvider getProvider() {
        return new ProtobufSchemaProvider();
    }

    @Override
    protected Message readFrom(String jsonString, ParsedSchema schema) {
        try {
            return (Message)ProtobufSchemaUtils.toObject((String)jsonString, (ProtobufSchema)((ProtobufSchema)schema));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Protobuf of schema %s", jsonString, schema), e);
        }
    }

    static class ProtobufMessageSerializer
    extends AbstractKafkaProtobufSerializer
    implements SchemaMessageSerializer<Message> {
        protected final Serializer keySerializer;

        ProtobufMessageSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, Serializer keySerializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.autoRegisterSchema = autoRegister;
            this.keySerializer = keySerializer;
        }

        @Override
        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        @Override
        public byte[] serializeKey(String topic, Object payload) {
            return this.keySerializer.serialize(topic, payload);
        }

        @Override
        public byte[] serialize(String subject, String topic, boolean isKey, Message object, ParsedSchema schema) {
            return super.serializeImpl(subject, topic, isKey, object, (ProtobufSchema)schema);
        }
    }
}

