/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.SimpleConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketIndexConcurrentFileWritesConflictResolutionStrategy
extends SimpleConcurrentFileWritesConflictResolutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BucketIndexConcurrentFileWritesConflictResolutionStrategy.class);

    @Override
    public boolean hasConflict(ConcurrentOperation thisOperation, ConcurrentOperation otherOperation) {
        Set partitionBucketIdSetForFirstInstant = thisOperation.getMutatedPartitionAndFileIds().stream().map(partitionAndFileId -> BucketIdentifier.partitionBucketIdStr((String)partitionAndFileId.getLeft(), BucketIdentifier.bucketIdFromFileId((String)partitionAndFileId.getRight()))).collect(Collectors.toSet());
        Set partitionBucketIdSetForSecondInstant = otherOperation.getMutatedPartitionAndFileIds().stream().map(partitionAndFileId -> BucketIdentifier.partitionBucketIdStr((String)partitionAndFileId.getLeft(), BucketIdentifier.bucketIdFromFileId((String)partitionAndFileId.getRight()))).collect(Collectors.toSet());
        HashSet intersection = new HashSet(partitionBucketIdSetForFirstInstant);
        intersection.retainAll(partitionBucketIdSetForSecondInstant);
        if (!intersection.isEmpty()) {
            LOG.info("Found conflicting writes between first operation = " + thisOperation + ", second operation = " + otherOperation + " , intersecting bucket ids " + intersection);
            return true;
        }
        return false;
    }
}

