/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.Serializable;
import java.util.Map;
import org.apache.hudi.common.util.collection.ImmutablePair;

public abstract class Pair<L, R>
implements Map.Entry<L, R>,
Comparable<Pair<L, R>>,
Serializable {
    private static final long serialVersionUID = 4954918890077093841L;

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new ImmutablePair<L, R>(left, right);
    }

    public abstract L getLeft();

    public abstract R getRight();

    @Override
    public final L getKey() {
        return this.getLeft();
    }

    @Override
    public R getValue() {
        return this.getRight();
    }

    @Override
    public int compareTo(Pair<L, R> other) {
        this.checkComparable(this);
        this.checkComparable(other);
        Comparable thisLeft = (Comparable)this.getLeft();
        Comparable thisRight = (Comparable)this.getRight();
        Comparable otherLeft = (Comparable)other.getLeft();
        Comparable otherRight = (Comparable)other.getRight();
        if (thisLeft.compareTo(otherLeft) == 0) {
            return thisRight.compareTo(otherRight);
        }
        return thisLeft.compareTo(otherLeft);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map.Entry) {
            Map.Entry other = (Map.Entry)obj;
            return this.getKey().equals(other.getKey()) && this.getValue().equals(other.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return "" + '(' + this.getLeft() + ',' + this.getRight() + ')';
    }

    public String toString(String format) {
        return String.format(format, this.getLeft(), this.getRight());
    }

    private void checkComparable(Pair<L, R> pair) {
        if (!(pair.getLeft() instanceof Comparable) || !(pair.getRight() instanceof Comparable)) {
            throw new IllegalArgumentException("Elements of Pair must implement Comparable :" + pair);
        }
    }
}

