/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import org.apache.hudi.common.util.hash.JenkinsHash;
import org.apache.hudi.common.util.hash.MurmurHash;

public abstract class Hash {
    public static final int INVALID_HASH = -1;
    public static final int JENKINS_HASH = 0;
    public static final int MURMUR_HASH = 1;

    public static int parseHashType(String name) {
        if ("jenkins".equalsIgnoreCase(name)) {
            return 0;
        }
        if ("murmur".equalsIgnoreCase(name)) {
            return 1;
        }
        return -1;
    }

    public static Hash getInstance(int type) {
        switch (type) {
            case 0: {
                return JenkinsHash.getInstance();
            }
            case 1: {
                return MurmurHash.getInstance();
            }
        }
        return null;
    }

    public int hash(byte[] bytes) {
        return this.hash(bytes, bytes.length, -1);
    }

    public int hash(byte[] bytes, int initval) {
        return this.hash(bytes, bytes.length, initval);
    }

    public abstract int hash(byte[] var1, int var2, int var3);
}

