/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.wal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class NettyAsyncFSWALConfigHelper {
    private static final String EVENT_LOOP_CONFIG = "hbase.wal.async.event-loop.config";
    private static final String CONFIG_NAME = "global-event-loop";
    private static final Map<String, Pair<EventLoopGroup, Class<? extends Channel>>> EVENT_LOOP_CONFIG_MAP = new HashMap<String, Pair<EventLoopGroup, Class<? extends Channel>>>();

    public static void setEventLoopConfig(Configuration conf, EventLoopGroup group, Class<? extends Channel> channelClass) {
        Preconditions.checkNotNull(group, "group is null");
        Preconditions.checkNotNull(channelClass, "channel class is null");
        conf.set(EVENT_LOOP_CONFIG, CONFIG_NAME);
        EVENT_LOOP_CONFIG_MAP.put(CONFIG_NAME, Pair.newPair(group, channelClass));
    }

    static Pair<EventLoopGroup, Class<? extends Channel>> getEventLoopConfig(Configuration conf) {
        String name = conf.get(EVENT_LOOP_CONFIG);
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return EVENT_LOOP_CONFIG_MAP.get(name);
    }

    private NettyAsyncFSWALConfigHelper() {
    }
}

