/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;

public class HoodieWriteMetadata<O> {
    private O writeStatuses;
    private Option<Duration> indexLookupDuration = Option.empty();
    private Option<Long> sourceReadAndIndexDurationMs = Option.empty();
    private boolean isCommitted;
    private Option<HoodieCommitMetadata> commitMetadata = Option.empty();
    private Option<List<HoodieWriteStat>> writeStats = Option.empty();
    private Option<Duration> indexUpdateDuration = Option.empty();
    private Option<Duration> finalizeDuration = Option.empty();
    private Option<Map<String, List<String>>> partitionToReplaceFileIds = Option.empty();

    public <T> HoodieWriteMetadata<T> clone(T transformedWriteStatuses) {
        HoodieWriteMetadata<T> newMetadataInstance = new HoodieWriteMetadata<T>();
        newMetadataInstance.setWriteStatuses(transformedWriteStatuses);
        if (this.indexLookupDuration.isPresent()) {
            newMetadataInstance.setIndexLookupDuration(this.indexLookupDuration.get());
        }
        if (this.sourceReadAndIndexDurationMs.isPresent()) {
            newMetadataInstance.setSourceReadAndIndexDurationMs(this.sourceReadAndIndexDurationMs.get());
        }
        newMetadataInstance.setCommitted(this.isCommitted);
        newMetadataInstance.setCommitMetadata(this.commitMetadata);
        if (this.writeStats.isPresent()) {
            newMetadataInstance.setWriteStats(this.writeStats.get());
        }
        if (this.indexUpdateDuration.isPresent()) {
            newMetadataInstance.setIndexUpdateDuration(this.indexUpdateDuration.get());
        }
        if (this.finalizeDuration.isPresent()) {
            newMetadataInstance.setFinalizeDuration(this.finalizeDuration.get());
        }
        if (this.partitionToReplaceFileIds.isPresent()) {
            newMetadataInstance.setPartitionToReplaceFileIds(this.partitionToReplaceFileIds.get());
        }
        return newMetadataInstance;
    }

    public O getWriteStatuses() {
        return this.writeStatuses;
    }

    public Option<HoodieCommitMetadata> getCommitMetadata() {
        return this.commitMetadata;
    }

    public void setWriteStatuses(O writeStatuses) {
        this.writeStatuses = writeStatuses;
    }

    public void setCommitMetadata(Option<HoodieCommitMetadata> commitMetadata) {
        this.commitMetadata = commitMetadata;
    }

    public Option<Duration> getFinalizeDuration() {
        return this.finalizeDuration;
    }

    public void setFinalizeDuration(Duration finalizeDuration) {
        this.finalizeDuration = Option.ofNullable(finalizeDuration);
    }

    public Option<Duration> getIndexUpdateDuration() {
        return this.indexUpdateDuration;
    }

    public void setIndexUpdateDuration(Duration indexUpdateDuration) {
        this.indexUpdateDuration = Option.ofNullable(indexUpdateDuration);
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setCommitted(boolean committed) {
        this.isCommitted = committed;
    }

    public Option<List<HoodieWriteStat>> getWriteStats() {
        return this.writeStats;
    }

    public void setWriteStats(List<HoodieWriteStat> writeStats) {
        this.writeStats = Option.of(writeStats);
    }

    public Option<Duration> getIndexLookupDuration() {
        return this.indexLookupDuration;
    }

    public void setIndexLookupDuration(Duration indexLookupDuration) {
        this.indexLookupDuration = Option.ofNullable(indexLookupDuration);
    }

    public Option<Long> getSourceReadAndIndexDurationMs() {
        return this.sourceReadAndIndexDurationMs;
    }

    public void setSourceReadAndIndexDurationMs(Long sourceReadAndIndexDurationMs) {
        this.sourceReadAndIndexDurationMs = Option.of(sourceReadAndIndexDurationMs);
    }

    public Map<String, List<String>> getPartitionToReplaceFileIds() {
        return this.partitionToReplaceFileIds.orElse(Collections.emptyMap());
    }

    public void setPartitionToReplaceFileIds(Map<String, List<String>> partitionToReplaceFileIds) {
        this.partitionToReplaceFileIds = Option.ofNullable(partitionToReplaceFileIds);
    }
}

