/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.table.HoodieTable;

public class CompactHelpers<T, I, K, O> {
    private static final CompactHelpers SINGLETON_INSTANCE = new CompactHelpers();

    private CompactHelpers() {
    }

    public static CompactHelpers getInstance() {
        return SINGLETON_INSTANCE;
    }

    public HoodieCommitMetadata createCompactionMetadata(HoodieTable table, String compactionInstantTime, HoodieData<WriteStatus> writeStatuses, String schema) throws IOException {
        byte[] planBytes = table.getActiveTimeline().readCompactionPlanAsBytes(HoodieTimeline.getCompactionRequestedInstant(compactionInstantTime)).get();
        HoodieCompactionPlan compactionPlan = TimelineMetadataUtils.deserializeCompactionPlan(planBytes);
        List<HoodieWriteStat> updateStatusMap = writeStatuses.map(WriteStatus::getStat).collectAsList();
        HoodieCommitMetadata metadata = new HoodieCommitMetadata(true);
        for (HoodieWriteStat stat : updateStatusMap) {
            metadata.addWriteStat(stat.getPartitionPath(), stat);
        }
        metadata.addMetadata("schema", schema);
        metadata.setOperationType(WriteOperationType.COMPACT);
        if (compactionPlan.getExtraMetadata() != null) {
            compactionPlan.getExtraMetadata().forEach(metadata::addMetadata);
        }
        return metadata;
    }

    public void completeInflightCompaction(HoodieTable table, String compactionCommitTime, HoodieCommitMetadata commitMetadata) {
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        try {
            activeTimeline.transitionCompactionInflightToComplete(HoodieTimeline.getCompactionInflightInstant(compactionCommitTime), Option.of(StringUtils.getUTF8Bytes(commitMetadata.toJsonString())));
        }
        catch (IOException e) {
            throw new HoodieCompactionException("Failed to commit " + table.getMetaClient().getBasePath() + " at time " + compactionCommitTime, e);
        }
    }

    public void completeInflightLogCompaction(HoodieTable table, String logCompactionCommitTime, HoodieCommitMetadata commitMetadata) {
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        try {
            activeTimeline.transitionLogCompactionInflightToComplete(HoodieTimeline.getLogCompactionInflightInstant(logCompactionCommitTime), Option.of(StringUtils.getUTF8Bytes(commitMetadata.toJsonString())));
        }
        catch (IOException e) {
            throw new HoodieCompactionException("Failed to commit " + table.getMetaClient().getBasePath() + " at time " + logCompactionCommitTime, e);
        }
    }

    public Option<InstantRange> getInstantRange(HoodieTableMetaClient metaClient) {
        return HoodieTableMetadata.isMetadataTable(metaClient.getBasePathV2().toString()) ? Option.of(this.getMetadataLogReaderInstantRange(metaClient)) : Option.empty();
    }

    private InstantRange getMetadataLogReaderInstantRange(HoodieTableMetaClient metadataMetaClient) {
        HoodieTableMetaClient dataMetaClient = HoodieTableMetaClient.builder().setConf(metadataMetaClient.getStorageConf().newInstance()).setBasePath(HoodieTableMetadata.getDatasetBasePath(metadataMetaClient.getBasePathV2().toString())).build();
        Set<String> validInstants = HoodieTableMetadataUtil.getValidInstantTimestamps(dataMetaClient, metadataMetaClient);
        return InstantRange.builder().rangeType(InstantRange.RangeType.EXPLICIT_MATCH).explicitInstants(validInstants).build();
    }
}

