/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.utilities.sources.processor.maxwell.PreCombineFieldType;

@ConfigClassProperty(name="Json Kafka Post Processor Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configurations controlling the post processor of Json Kafka Source in Hudi Streamer.")
@Immutable
public class JsonKafkaPostProcessorConfig
extends HoodieConfig {
    public static final ConfigProperty<String> JSON_KAFKA_PROCESSOR_CLASS = ConfigProperty.key("hoodie.streamer.source.json.kafka.processor.class").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.json.kafka.processor.class").markAdvanced().withDocumentation("Json kafka source post processor class name, post process data after consuming fromsource and before giving it to Hudi Streamer.");
    public static final ConfigProperty<String> DATABASE_NAME_REGEX = ConfigProperty.key("hoodie.streamer.source.json.kafka.post.processor.maxwell.database.regex").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.json.kafka.post.processor.maxwell.database.regex").markAdvanced().withDocumentation("Database name regex");
    public static final ConfigProperty<String> TABLE_NAME_REGEX = ConfigProperty.key("hoodie.streamer.source.json.kafka.post.processor.maxwell.table.regex").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.json.kafka.post.processor.maxwell.table.regex").markAdvanced().withDocumentation("Table name regex");
    public static final ConfigProperty<String> PRECOMBINE_FIELD_TYPE = ConfigProperty.key("hoodie.streamer.source.json.kafka.post.processor.maxwell.precombine.field.type").defaultValue(PreCombineFieldType.DATE_STRING.toString()).withAlternatives("hoodie.deltastreamer.source.json.kafka.post.processor.maxwell.precombine.field.type").markAdvanced().withDocumentation("Data type of the preCombine field. could be NON_TIMESTAMP, DATE_STRING,UNIX_TIMESTAMP or EPOCHMILLISECONDS. DATE_STRING by default");
    public static final ConfigProperty<String> PRECOMBINE_FIELD_FORMAT = ConfigProperty.key("hoodie.streamer.source.json.kafka.post.processor.maxwell.precombine.field.format").defaultValue("yyyy-MM-dd HH:mm:ss").withAlternatives("hoodie.deltastreamer.source.json.kafka.post.processor.maxwell.precombine.field.format").markAdvanced().withDocumentation("When the preCombine filed is in DATE_STRING format, use should tell hoodiewhat format it is. 'yyyy-MM-dd HH:mm:ss' by default");
}

