/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

@ConfigClassProperty(name="Kafka Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configurations controlling the behavior of Kafka source in Hudi Streamer.")
@Immutable
public class KafkaSourceConfig
extends HoodieConfig {
    private static final String PREFIX = "hoodie.streamer.source.kafka.";
    private static final String OLD_PREFIX = "hoodie.deltastreamer.source.kafka.";
    public static final ConfigProperty<String> KAFKA_CHECKPOINT_TYPE = ConfigProperty.key("hoodie.streamer.source.kafka.checkpoint.type").defaultValue("string").withAlternatives("hoodie.deltastreamer.source.kafka.checkpoint.type").markAdvanced().withDocumentation("Kafka checkpoint type.");
    public static final ConfigProperty<String> KAFKA_AVRO_VALUE_DESERIALIZER_CLASS = ConfigProperty.key("hoodie.streamer.source.kafka.value.deserializer.class").defaultValue("io.confluent.kafka.serializers.KafkaAvroDeserializer").withAlternatives("hoodie.deltastreamer.source.kafka.value.deserializer.class").markAdvanced().sinceVersion("0.9.0").withDocumentation("This class is used by kafka client to deserialize the records.");
    public static final ConfigProperty<String> KAFKA_VALUE_DESERIALIZER_SCHEMA = ConfigProperty.key("hoodie.streamer.source.kafka.value.deserializer.schema").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.kafka.value.deserializer.schema").markAdvanced().withDocumentation("Schema to deserialize the records.");
    public static final ConfigProperty<Long> KAFKA_FETCH_PARTITION_TIME_OUT = ConfigProperty.key("hoodie.streamer.source.kafka.fetch_partition.time.out").defaultValue(300000L).withAlternatives("hoodie.deltastreamer.source.kafka.fetch_partition.time.out").markAdvanced().withDocumentation("Time out for fetching partitions. 5min by default");
    public static final ConfigProperty<Boolean> ENABLE_KAFKA_COMMIT_OFFSET = ConfigProperty.key("hoodie.streamer.source.kafka.enable.commit.offset").defaultValue(false).withAlternatives("hoodie.deltastreamer.source.kafka.enable.commit.offset").markAdvanced().withDocumentation("Automatically submits offset to kafka.");
    public static final ConfigProperty<Boolean> ENABLE_FAIL_ON_DATA_LOSS = ConfigProperty.key("hoodie.streamer.source.kafka.enable.failOnDataLoss").defaultValue(false).withAlternatives("hoodie.deltastreamer.source.kafka.enable.failOnDataLoss").markAdvanced().withDocumentation("Fail when checkpoint goes out of bounds instead of seeking to earliest offsets.");
    public static final ConfigProperty<Long> MAX_EVENTS_FROM_KAFKA_SOURCE = ConfigProperty.key("hoodie.streamer.kafka.source.maxEvents").defaultValue(5000000L).withAlternatives("hoodie.deltastreamer.kafka.source.maxEvents").markAdvanced().withDocumentation("Maximum number of records obtained in each batch.");
    public static final ConfigProperty<Long> KAFKA_SOURCE_MIN_PARTITIONS = ConfigProperty.key("hoodie.streamer.source.kafka.minPartitions").defaultValue(0L).withAlternatives("hoodie.deltastreamer.source.kafka.minPartitions").markAdvanced().sinceVersion("0.14.0").withDocumentation("Desired minimum number of partitions to read from Kafka. By default, Hudi has a 1-1 mapping of topicPartitions to Hudi partitions consuming from Kafka. If set this option to a value greater than topicPartitions, Hudi will divvy up large Kafka partitions to smaller pieces. Please note that this configuration is like a hint: the number of input tasks will be approximately minPartitions. It can be less or more depending on rounding errors or Kafka partitions that didn't receive any new data.");
    public static final ConfigProperty<String> KAFKA_TOPIC_NAME = ConfigProperty.key("hoodie.streamer.source.kafka.topic").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.kafka.topic").withDocumentation("Kafka topic name.");
    public static final ConfigProperty<KafkaResetOffsetStrategies> KAFKA_AUTO_OFFSET_RESET = ConfigProperty.key("auto.offset.reset").defaultValue(KafkaResetOffsetStrategies.LATEST).markAdvanced().withDocumentation("Kafka consumer strategy for reading data.");
    public static final ConfigProperty<String> KAFKA_PROTO_VALUE_DESERIALIZER_CLASS = ConfigProperty.key("hoodie.streamer.source.kafka.proto.value.deserializer.class").defaultValue(ByteArrayDeserializer.class.getName()).sinceVersion("0.15.0").withDocumentation("Kafka Proto Payload Deserializer Class");

    public static enum KafkaResetOffsetStrategies {
        LATEST,
        EARLIEST,
        GROUP;

    }
}

