/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.utilities.config.FilebasedSchemaProviderConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaProviderException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.helpers.SanitizationUtils;
import org.apache.spark.api.java.JavaSparkContext;

public class FilebasedSchemaProvider
extends SchemaProvider {
    private final FileSystem fs;
    private final String sourceFile;
    private final String targetFile;
    private final boolean shouldSanitize;
    private final String invalidCharMask;
    protected Schema sourceSchema;
    protected Schema targetSchema;

    public FilebasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(FilebasedSchemaProviderConfig.SOURCE_SCHEMA_FILE));
        this.sourceFile = ConfigUtils.getStringWithAltKeys(props, FilebasedSchemaProviderConfig.SOURCE_SCHEMA_FILE);
        this.targetFile = ConfigUtils.getStringWithAltKeys(props, FilebasedSchemaProviderConfig.TARGET_SCHEMA_FILE, this.sourceFile);
        this.shouldSanitize = SanitizationUtils.shouldSanitize(props);
        this.invalidCharMask = SanitizationUtils.getInvalidCharMask(props);
        this.fs = HadoopFSUtils.getFs(this.sourceFile, jssc.hadoopConfiguration(), true);
        this.sourceSchema = this.parseSchema(this.sourceFile);
        if (ConfigUtils.containsConfigProperty(props, FilebasedSchemaProviderConfig.TARGET_SCHEMA_FILE)) {
            this.targetSchema = this.parseSchema(this.targetFile);
        }
    }

    private Schema parseSchema(String schemaFile) {
        return FilebasedSchemaProvider.readAvroSchemaFromFile(schemaFile, this.fs, this.shouldSanitize, this.invalidCharMask);
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }

    private static Schema readAvroSchemaFromFile(String schemaPath, FileSystem fs, boolean sanitizeSchema, String invalidCharMask) {
        String schemaStr;
        try (FSDataInputStream in = fs.open(new Path(schemaPath));){
            schemaStr = FileIOUtils.readAsUTFString((InputStream)in);
        }
        catch (IOException ioe) {
            throw new HoodieSchemaProviderException(String.format("Error reading schema from file %s", schemaPath), ioe);
        }
        return SanitizationUtils.parseAvroSchema(schemaStr, sanitizeSchema, invalidCharMask);
    }

    @Override
    public void refresh() {
        this.sourceSchema = this.parseSchema(this.sourceFile);
        this.targetSchema = this.parseSchema(this.targetFile);
    }
}

