/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.converter;

import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.io.IOException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;
import org.apache.hudi.utilities.sources.helpers.ProtoConversionUtil;

public class ProtoSchemaToAvroSchemaConverter
implements SchemaRegistryProvider.SchemaConverter {
    private final ProtoConversionUtil.SchemaConfig schemaConfig;

    public ProtoSchemaToAvroSchemaConverter(TypedProperties config) {
        this.schemaConfig = ProtoConversionUtil.SchemaConfig.fromProperties(config);
    }

    @Override
    public String convert(String schema) throws IOException {
        ProtobufSchema protobufSchema = new ProtobufSchema(schema);
        return ProtoConversionUtil.getAvroSchemaForMessageDescriptor(protobufSchema.toDescriptor(), this.schemaConfig).toString();
    }
}

