/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.postprocessor.add;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.utilities.config.SchemaProviderPostProcessorConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaPostProcessException;
import org.apache.hudi.utilities.schema.SchemaPostProcessor;
import org.apache.spark.api.java.JavaSparkContext;

public class AddPrimitiveColumnSchemaPostProcessor
extends SchemaPostProcessor {
    public AddPrimitiveColumnSchemaPostProcessor(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
    }

    @Override
    public Schema processSchema(Schema schema) {
        String newColumnName = ConfigUtils.getStringWithAltKeys(this.config, SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NAME_PROP);
        if (schema.getField(newColumnName) != null) {
            throw new HoodieSchemaPostProcessException(String.format("Column %s already exist!", newColumnName));
        }
        List sourceFields = schema.getFields();
        ArrayList<Schema.Field> targetFields = new ArrayList<Schema.Field>(sourceFields.size() + 1);
        for (Schema.Field sourceField : sourceFields) {
            targetFields.add(new Schema.Field(sourceField.name(), sourceField.schema(), sourceField.doc(), sourceField.defaultVal()));
        }
        targetFields.add(this.buildNewColumn());
        return Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false, targetFields);
    }

    private Schema.Field buildNewColumn() {
        String columnName = ConfigUtils.getStringWithAltKeys(this.config, SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NAME_PROP);
        String type = ConfigUtils.getStringWithAltKeys(this.config, SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_TYPE_PROP).toUpperCase(Locale.ROOT);
        String doc = ConfigUtils.getStringWithAltKeys(this.config, SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_DOC_PROP, true);
        Option<Object> defaultValue = ConfigUtils.getRawValueWithAltKeys(this.config, SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_DEFAULT_PROP);
        boolean nullable = ConfigUtils.getBooleanWithAltKeys(this.config, SchemaProviderPostProcessorConfig.SCHEMA_POST_PROCESSOR_ADD_COLUMN_NULLABLE_PROP);
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(columnName));
        ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(type));
        ValidationUtils.checkArgument(!Schema.Type.NULL.getName().equals(type));
        Schema newSchema = this.createSchema(type, nullable);
        return new Schema.Field(columnName, newSchema, doc, defaultValue.isPresent() ? defaultValue.get() : null);
    }

    private Schema createSchema(String type, boolean nullable) {
        Schema schema = Schema.create((Schema.Type)Schema.Type.valueOf((String)type));
        if (nullable) {
            schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema});
        }
        return schema;
    }
}

