/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Collections;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.config.CloudSourceConfig;
import org.apache.hudi.utilities.config.HoodieIncrSourceConfig;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.HoodieIncrSource;
import org.apache.hudi.utilities.sources.SnapshotLoadQuerySplitter;
import org.apache.hudi.utilities.sources.helpers.CloudDataFetcher;
import org.apache.hudi.utilities.sources.helpers.CloudObjectIncrCheckpoint;
import org.apache.hudi.utilities.sources.helpers.CloudObjectsSelectorCommon;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.hudi.utilities.sources.helpers.QueryInfo;
import org.apache.hudi.utilities.sources.helpers.QueryRunner;
import org.apache.hudi.utilities.streamer.DefaultStreamContext;
import org.apache.hudi.utilities.streamer.StreamContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsEventsHoodieIncrSource
extends HoodieIncrSource {
    private final String srcPath;
    private final boolean checkIfFileExists;
    private final int numInstantsPerFetch;
    private final IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy;
    private final CloudDataFetcher cloudDataFetcher;
    private final QueryRunner queryRunner;
    private final Option<SchemaProvider> schemaProvider;
    private final Option<SnapshotLoadQuerySplitter> snapshotLoadQuerySplitter;
    private static final Logger LOG = LoggerFactory.getLogger(GcsEventsHoodieIncrSource.class);

    public GcsEventsHoodieIncrSource(TypedProperties props, JavaSparkContext jsc, SparkSession spark, SchemaProvider schemaProvider, HoodieIngestionMetrics metrics) {
        this(props, jsc, spark, new CloudDataFetcher(props, jsc, spark, metrics), new QueryRunner(spark, props), new DefaultStreamContext(schemaProvider, Option.empty()));
    }

    public GcsEventsHoodieIncrSource(TypedProperties props, JavaSparkContext jsc, SparkSession spark, HoodieIngestionMetrics metrics, StreamContext streamContext) {
        this(props, jsc, spark, new CloudDataFetcher(props, jsc, spark, metrics), new QueryRunner(spark, props), streamContext);
    }

    GcsEventsHoodieIncrSource(TypedProperties props, JavaSparkContext jsc, SparkSession spark, CloudDataFetcher cloudDataFetcher, QueryRunner queryRunner, StreamContext streamContext) {
        super(props, jsc, spark, streamContext);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH));
        this.srcPath = ConfigUtils.getStringWithAltKeys(props, HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH);
        this.missingCheckpointStrategy = IncrSourceHelper.getMissingCheckpointStrategy(props);
        this.numInstantsPerFetch = ConfigUtils.getIntWithAltKeys(props, HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH);
        this.checkIfFileExists = ConfigUtils.getBooleanWithAltKeys(props, CloudSourceConfig.ENABLE_EXISTS_CHECK);
        this.cloudDataFetcher = cloudDataFetcher;
        this.queryRunner = queryRunner;
        this.schemaProvider = Option.ofNullable(streamContext.getSchemaProvider());
        this.snapshotLoadQuerySplitter = SnapshotLoadQuerySplitter.getInstance(props);
        LOG.info("srcPath: " + this.srcPath);
        LOG.info("missingCheckpointStrategy: " + (Object)((Object)this.missingCheckpointStrategy));
        LOG.info("numInstantsPerFetch: " + this.numInstantsPerFetch);
        LOG.info("checkIfFileExists: " + this.checkIfFileExists);
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCheckpoint, long sourceLimit) {
        CloudObjectIncrCheckpoint cloudObjectIncrCheckpoint = CloudObjectIncrCheckpoint.fromString(lastCheckpoint);
        TimelineUtils.HollowCommitHandling handlingMode = IncrSourceHelper.getHollowCommitHandleMode(this.props);
        QueryInfo queryInfo = IncrSourceHelper.generateQueryInfo(this.sparkContext, this.srcPath, this.numInstantsPerFetch, Option.of(cloudObjectIncrCheckpoint.getCommit()), this.missingCheckpointStrategy, handlingMode, HoodieRecord.COMMIT_TIME_METADATA_FIELD, "name", "size", true, Option.ofNullable(cloudObjectIncrCheckpoint.getKey()));
        LOG.info("Querying GCS with:" + cloudObjectIncrCheckpoint + " and queryInfo:" + queryInfo);
        if (StringUtils.isNullOrEmpty(cloudObjectIncrCheckpoint.getKey()) && queryInfo.areStartAndEndInstantsEqual()) {
            LOG.info("Source of file names is empty. Returning empty result and endInstant: " + queryInfo.getStartInstant());
            return Pair.of(Option.empty(), queryInfo.getStartInstant());
        }
        return this.cloudDataFetcher.fetchPartitionedSource(CloudObjectsSelectorCommon.Type.GCS, cloudObjectIncrCheckpoint, this.sourceProfileSupplier, this.queryRunner.run(queryInfo, this.snapshotLoadQuerySplitter), this.schemaProvider, sourceLimit);
    }
}

